/*
 * Decompiled with CFR 0.152.
 */
package UI;

import Function.BasicFun;
import Function.MainModel;
import Util.CustomTable;
import Util.Log;
import Util.WebAppRes;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.border.BevelBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class MainView
extends JPanel
implements MouseListener,
ActionListener {
    private final String[] m_Headings = new String[]{WebAppRes.GetString("IDS_PRINTER_NAME"), WebAppRes.GetString("IDS_MAC_ADDR"), WebAppRes.GetString("IDS_IP_ADDR"), WebAppRes.GetString("IDS_SUBNET_ADDR"), WebAppRes.GetString("IDS_GATEWAY_ADDR")};
    private final int[] m_colWidth = new int[]{142, 117, 117, 117, 117};
    public CustomTable m_TableList = null;
    private JScrollPane jsp = null;
    private MainModel model;
    private JPopupMenu popup;

    public MainView() {
        this.setLayout(new BorderLayout());
        this.CreateControl();
        this.createMenu();
        this.setSize(610, 320);
        this.setBackground(new Color(247, 247, 247));
    }

    private void CreateControl() {
        this.m_TableList = new CustomTable(0, this.m_Headings, this.m_colWidth);
        this.m_TableList.setShowHorizontalLines(false);
        this.m_TableList.addMouseListener(this);
        this.jsp = new JScrollPane(this.m_TableList);
        this.jsp.setVerticalScrollBarPolicy(20);
        this.add((Component)this.jsp, "Center");
    }

    public void addModel(MainModel mainModel) {
        this.model = mainModel;
    }

    private void createMenu() {
        Color color = new Color(247, 247, 247);
        this.popup = new JPopupMenu();
        this.popup.setBackground(color);
        this.popup.add(this.addMenuItem(color, WebAppRes.GetString("IDS_SETUP")));
        this.popup.add(this.addMenuItem(color, WebAppRes.GetString("IDS_MAN_SET")));
        this.popup.addSeparator();
        this.popup.add(this.addMenuItem(color, WebAppRes.GetString("IDS_REFRESH")));
        this.popup.add(this.addMenuItem(color, WebAppRes.GetString("IDS_LAUNCH")));
        this.popup.addSeparator();
        this.popup.add(this.addMenuItem(color, WebAppRes.GetString("IDS_ABOUTBOX")));
        this.popup.setLabel("Justification");
        this.popup.setBorder(new BevelBorder(0));
        this.popup.addPopupMenuListener(new PopupPrintListener());
    }

    public void reCreateMenu() {
        Color color = new Color(247, 247, 247);
        this.popup.removeAll();
        this.popup.setBackground(color);
        this.popup.add(this.addMenuItem(color, WebAppRes.GetString("IDS_SETUP")));
        this.popup.add(this.addMenuItem(color, WebAppRes.GetString("IDS_MAN_SET")));
        this.popup.addSeparator();
        this.popup.add(this.addMenuItem(color, WebAppRes.GetString("IDS_REFRESH")));
        this.popup.add(this.addMenuItem(color, WebAppRes.GetString("IDS_LAUNCH")));
        this.popup.addSeparator();
        this.popup.add(this.addMenuItem(color, WebAppRes.GetString("IDS_ABOUTBOX")));
        this.popup.setLabel("Justification");
        this.popup.setBorder(new BevelBorder(0));
        String[] stringArray = new String[]{WebAppRes.GetString("IDS_PRINTER_NAME"), WebAppRes.GetString("IDS_MAC_ADDR"), WebAppRes.GetString("IDS_IP_ADDR"), WebAppRes.GetString("IDS_SUBNET_ADDR"), WebAppRes.GetString("IDS_GATEWAY_ADDR")};
        for (int i = 0; i < this.m_TableList.getColumnModel().getColumnCount(); ++i) {
            this.m_TableList.getColumnModel().getColumn(i).setHeaderValue(stringArray[i]);
        }
    }

    private JMenuItem addMenuItem(Color color, String string) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.setHorizontalTextPosition(2);
        jMenuItem.addActionListener(this);
        jMenuItem.setBackground(color);
        return jMenuItem;
    }

    private void checkPopup(MouseEvent mouseEvent) {
        int n;
        if (mouseEvent.isMetaDown() && (n = this.m_TableList.rowAtPoint(mouseEvent.getPoint())) >= 0) {
            this.m_TableList.setRowSelectionInterval(n, n);
            this.model.enableAutoSetButton(true);
        }
        if (mouseEvent.isPopupTrigger()) {
            this.popup.show(this.m_TableList, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void removeRowAll() {
        this.m_TableList.removeRowAll();
    }

    public void SetItem(String[] stringArray) {
        Log.write(0, "StoredQueueView.SetItem() : sJob[0] = " + stringArray[0] + " sJob[1] = " + stringArray[1] + " sJob[2] = " + stringArray[2] + " sJob[3] = " + stringArray[3] + " sJob[4] = " + stringArray[4]);
        this.m_TableList.addItem(stringArray);
    }

    public String[] getSelectedRowData() {
        return this.m_TableList.getRowItems(this.m_TableList.getSelectedRow());
    }

    public String getSelectedRowIP() {
        String[] stringArray = this.m_TableList.getRowItems(this.m_TableList.getSelectedRow());
        if (stringArray == null) {
            return null;
        }
        return stringArray[2];
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.checkPopup(mouseEvent);
        if (this.m_TableList.getSelectedRow() < 0 || this.m_TableList.getSelectedColumn() < 0) {
            return;
        }
        if (mouseEvent.getClickCount() == 2) {
            this.model.loadSetWindow(true);
        } else {
            this.model.enableAutoSetButton(true);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.checkPopup(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.checkPopup(mouseEvent);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Log.write(0, "Popup menu item [" + actionEvent.getActionCommand() + "] was pressed.");
        if (actionEvent.getActionCommand().compareTo(WebAppRes.GetString("IDS_SETUP")) == 0) {
            this.model.loadSetWindow(true);
        } else if (actionEvent.getActionCommand().compareTo(WebAppRes.GetString("IDS_MAN_SET")) == 0) {
            this.model.loadSetWindow(false);
        } else if (actionEvent.getActionCommand().compareTo(WebAppRes.GetString("IDS_REFRESH")) == 0) {
            this.model.getPacket();
        } else if (actionEvent.getActionCommand().compareTo(WebAppRes.GetString("IDS_LAUNCH")) == 0) {
            this.model.goPrintServer();
        } else if (actionEvent.getActionCommand().compareTo(WebAppRes.GetString("IDS_ABOUTBOX")) == 0) {
            this.model.loadInfoWindow();
        }
    }

    public void setValueAt(String string, String string2, String string3, String string4) {
        int n = this.m_TableList.getSelectedRow();
        Log.write(0, "Current row is " + n);
        this.m_TableList.sorter.setValueAt(string, n, 1);
        this.m_TableList.sorter.setValueAt(string2, n, 2);
        this.m_TableList.sorter.setValueAt(string3, n, 3);
        this.m_TableList.sorter.setValueAt(string4, n, 4);
        this.m_TableList.sorter.setValueAt(BasicFun.fullIP(string2), n, 5);
        this.m_TableList.sorter.setValueAt(BasicFun.fullIP(string3), n, 6);
        this.m_TableList.sorter.setValueAt(BasicFun.fullIP(string4), n, 7);
    }

    class PopupPrintListener
    implements PopupMenuListener {
        PopupPrintListener() {
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            Log.write(0, "Popup menu will be visible!");
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            Log.write(0, "Popup menu will be invisible!");
        }

        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            Log.write(0, "Popup menu is hidden!");
        }
    }

    class MousePopupListener
    extends MouseAdapter {
        MousePopupListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            MainView.this.checkPopup(mouseEvent);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            MainView.this.checkPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            MainView.this.checkPopup(mouseEvent);
        }
    }
}

