unit BXIOLON_Sample;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, bxllib, StdCtrls;

type
  TForm_BIXOLON = class(TForm)
    lblDllVersion: TLabel;
    Label1: TLabel;
    Label3: TLabel;
    cmbPrtList: TComboBox;
    GroupBox1: TGroupBox;
    Label4: TLabel;
    Label5: TLabel;
    edtP_Width: TEdit;
    edtP_Height: TEdit;
    GroupBox2: TGroupBox;
    Label6: TLabel;
    Label7: TLabel;
    edtMargin_X: TEdit;
    edtMargin_Y: TEdit;
    GroupBox3: TGroupBox;
    Label8: TLabel;
    Label9: TLabel;
    btnSearchPrinter: TButton;
    cmbSpeed: TComboBox;
    cmbDensity: TComboBox;
    GroupBox4: TGroupBox;
    rdoMT_DT: TRadioButton;
    rdoMT_TT: TRadioButton;
    GroupBox5: TGroupBox;
    rdoST_Gap: TRadioButton;
    rdoST_BM: TRadioButton;
    GroupBox6: TGroupBox;
    rdoST_Continuous: TRadioButton;
    chkCutter: TCheckBox;
    chkBackfeeding: TCheckBox;
    btnPrintLabel: TButton;
    procedure FormCreate(Sender: TObject);
    procedure btnSearchPrinterClick(Sender: TObject);
    procedure btnPrintLabelClick(Sender: TObject);
  private
    procedure InitControls;
    function GetInstalledPrinter : Boolean;
    procedure Split(const Delimiter: Char; Input: string; var Strings: TStringList);
  public
    { Public declarations }
  end;

var
  Form_BIXOLON: TForm_BIXOLON;

implementation

{$R *.dfm}

procedure TForm_BIXOLON.FormCreate(Sender: TObject);
begin
  InitControls();
end;

procedure TForm_BIXOLON.InitControls;
var
  dbValue : Double;
  pDllVersion : PChar;
begin

  pDllVersion := AllocMem(256);
  if GetDllVersion(pDllVersion) = true then
  begin
    lblDllVersion.Caption := 'Version ' + StrPas(pDllVersion);
  end
  else begin
    lblDllVersion.Caption := 'Unknown';
  end;

  if pDllVersion <> Nil then FreeMem(pDllVersion);

  //
  btnPrintLabel.Enabled := GetInstalledPrinter();

  // paper size
  // Default 4x6 inch -> (4 * 25.4) x (6 * 25.4) mm

  // paper width
  dbValue := 4 * 25.4;
  edtP_Width.Text := FormatFloat('##0.###', dbValue);
  // paper height
  dbValue := 6 * 25.4;
  edtP_Height.Text := FormatFloat('##0.###', dbValue);

  // Margins
  edtMargin_X.Text := '0';
  edtMargin_Y.Text := '0';

  // Speed/Density
  cmbSpeed.ItemIndex := SPEED_50;
  cmbDensity.ItemIndex := 14 - 1;

  // Media type(default : Direct thermal)
  rdoMT_DT.Checked := true;

  // Sensor type(default : GAP)
  rdoST_Gap.Checked := true;

  // Reverse-feeding enable
  chkBackfeeding.Checked := true;


end;


function TForm_BIXOLON.GetInstalledPrinter : Boolean;
var
  nIndex,nResult : Integer;
  pGetPrinters : PChar;
  pPrtList : TStringList;
begin
  nResult := 0;
  pGetPrinters := Nil;
  pPrtList := Nil;

  pGetPrinters := AllocMem(4096);
  pPrtList := TStringList.Create;

  try
    cmbPrtList.Items.Clear;
    if GetBIXOLON_PrinterList(pGetPrinters) > 0 then
    begin
      Split('^', pGetPrinters, pPrtList);
      nResult := pPrtList.Count;
      for nIndex := 0 to nResult - 1 do
      begin
        cmbPrtList.Items.Add(pPrtList.Strings[nIndex]);
      end;

      cmbPrtList.ItemIndex := 0;
      Result := true;
    end
    else begin
      Result := false
    end;
  finally
    FreeMem(pGetPrinters);
    pPrtList.Free;
  end;

end;

procedure TForm_BIXOLON.Split(const Delimiter: Char; Input: string; var Strings: TStringList);
begin
   Assert(Assigned(Strings)) ; 
   Strings.Clear; 
   ExtractStrings([Delimiter], [' '], PChar(Input), Strings); 
end;

procedure TForm_BIXOLON.btnSearchPrinterClick(Sender: TObject);
begin
  btnPrintLabel.Enabled := GetInstalledPrinter();
end;

procedure TForm_BIXOLON.btnPrintLabelClick(Sender: TObject);
var
  pPrinterName : PChar;
  nPaper_Width : Integer;
  nPaper_Height : Integer;
  nMarginX : Integer;
  nMarginY : Integer;
  nSpeed : Integer;
  nDensity : Integer;
  bAutoCut : Boolean;
  bReverseFeeding : Boolean;
  nSensorType : Integer;
  pMediaType : PChar;
  MM2D : Integer;
  Direct_MaxiCode_2DBarcode_Cmd : PChar;
  Direct_PDF_2DBarcocde_Cmd : PChar;
  QRCode_data : PChar;
begin
  try
    pPrinterName := PChar(cmbPrtList.Items[cmbPrtList.ItemIndex]);
    // BIXOLON SLP-770II, BIXOLON SLP-770III
    // BIXOLON SLP-D420, BIXOLON SLP-D423, BIXOLON SLP-T400, BIXOLON SLP-T403,
    // BIXOLON SLP-TX400, BIXOLON SLP-TX403 ...
    // ...
    //strPrinterName = "\\\\192.168.100.191\\BIXOLON SRP-770III";

    if ConnectPrinter(pPrinterName) = true then
    begin
      // 203 DPI : 1mm = 8 dots
      // 300 DPI : 1mm = 12 dots
      MM2D := 8;
      if GetPrinterResolution() > 203 then MM2D := 12;

      // paper size
      //nPaper_Width := StrToInt(floatToStr((StrToFloat(edtP_Width.Text) * MM2D)));
      nPaper_Width := trunc(StrToFloat(edtP_Width.Text) * MM2D);
      nPaper_Height := trunc(StrToFloat(edtP_Height.Text) * MM2D);
      // Margins
      nMarginX := trunc(StrToFloat(edtMargin_X.Text) * MM2D);
      nMarginY := trunc(StrToFloat(edtMargin_Y.Text) * MM2D);
      // Speed / Density
      nSpeed := cmbSpeed.ItemIndex;
      nDensity := cmbDensity.ItemIndex + 1;
      // Media type
      pMediaType := 'STd';
      if rdoMT_TT.Checked = true then pMediaType := 'STt';
      // Sensor type
      nSensorType := GAP;
      if rdoST_BM.Checked = true then nSensorType := BLACKMARK;
      if rdoST_Continuous.Checked = true then nSensorType := CONTINUOUS;
      // Auto cutter
      bAutoCut := chkCutter.Checked;
      // Reverse-feeding
      bReverseFeeding := chkBackfeeding.Checked;

      //-----------------------------------------------------------------------
      //	Set the label start
      StartLabel();

      //	Set Label and Printer
      //SetConfigOfPrinter(SPEED_50, 17, TOP, false, 0, true);
      SetConfigOfPrinter(nSpeed, nDensity, TOP, bAutoCut, 0, bReverseFeeding);

      // 1 Inch : 25.4mm
      // 1 mm   :  8 Dot in 203 DPI such as TX400, T400, D420, D220, SRP-770, SRP-770II
      // 1 mm   : 12 Dot in 300 DPI such as TX403, T403, D423, D223
      // 4 Inch : 25.4  * 4 * 8 = 812.8
      // 6 Inch : 25.4  * 4 * 8 = 1219.2

      //SetPaper(16, 16, 813, 1220, GAP, 0, 16); // 4 inch (Width) * 6 inch (Hiehgt)
      SetPaper(nMarginX, nMarginY, nPaper_Width, nPaper_Height, nSensorType, 0, 16); // 4 inch (Width) * 6 inch (Hiehgt)

      PrintDirect(pMediaType);

      //	Clear Buffer of Printer
      ClearBuffer();


      // Draw BOX (Fill color is black)
      PrintBlock(370, 40, 760, 150, LINE_OVER_WRITING, 0);

      //	Draw Lines
      PrintBlock(18, 164, 798, 170, LINE_OVER_WRITING, 0);
      PrintBlock(18, 410, 784, 415, LINE_OVER_WRITING, 0);
      //PrintBlock(553, 170, 558, 413, LINE_OVER_WRITING, 0);
      PrintBlock(548, 170, 553, 413, LINE_OVER_WRITING, 0);
      PrintBlock(18, 616, 784, 621, LINE_OVER_WRITING, 0);
      PrintBlock(20, 781, 786, 786, LINE_OVER_WRITING, 0);
      PrintBlock(18, 928, 784, 933, LINE_OVER_WRITING, 0);
      PrintBlock(241, 783, 246, 932, LINE_OVER_WRITING, 0);
      PrintBlock(486, 784, 491, 933, LINE_OVER_WRITING, 0);


      // Prints string using TrueFont
      //  P1 : Horizontal position (X) [dot]
      //  P2 : Vertical position (Y) [dot]
      //  P3 : Font Name
      //  P4 : Font Size
      //  P5 : Rotation : (0 : 0 degree , 1 : 90 degree, 2 : 180 degree, 3 : 270 degree)
      //  P6 : Italic
      //  P7 : Bold
      //  P8 : Underline
      PrintTrueFontLib(22, 100, 'Arial', 16, 0, true, true, false, 'Sample Label-1');

      //Print string using Vector Font
      //  P1 : Horizontal position (X) [dot]
      //  P2 : Vertical position (Y) [dot]
      //  P3 : Font selection
      //                  U: ASCII (1Byte code)
      //                  K: KS5601 (2Byte code)
      //                  B: BIG5 (2Byte code)
      //                  G: GB2312 (2Byte code)
      //                  J: Shift-JIS (2Byte code)
      // P4  : Font width (W)[dot]
      // P5  : Font height (H)[dot]
      // P6  : Right-side character spacing [dot], Plus (+)/Minus (-) option can be used. Ex) 5, +3, -10
      // P7  : Bold
      // P8  : Reverse printing
      // P9  : Text style  (N : Normal, I : Italic)
      // P10 : Rotation (0 ~ 3)
      // P11 : Text Alignment (Optional)
      // P12 : Text string write direction
      // P13 : data to print
      // ※ : Third parameter, 'ASCII' must be set if Bixolon printer is SLP-T400, SLP-T403, SRP-770 and SRP-770II.
      //PrintVectorFont(22, 65, ASCII, 34, 34, "0", false, false, false, ROTATE_0, LEFTALIGN, LEFTTORIGHT, "Sample Label-2");

      PrintDeviceFont(400, 55, ENG_48X76, 1, 1, ROTATE_0, false, 'BIXOLON');

      PrintDeviceFont(20, 174, ENG_24X38, 1, 1, ROTATE_0, false, 'SHIP TO:');
      PrintDeviceFont(20, 234, ENG_19X30, 1, 1, ROTATE_0, true, 'BIXOLON');
      PrintDeviceFont(20, 280, ENG_16X25, 1, 1, ROTATE_0, false, '7th FL, MiraeAsset Venture Tower,');
      PrintDeviceFont(20, 310, ENG_16X25, 1, 1, ROTATE_0, false, '685, Sampyeong-dong, Bundang-gu,');
      PrintDeviceFont(20, 340, ENG_16X25, 1, 1, ROTATE_0, false, 'Seongnam-si, Gyeonggi-do,');
      PrintDeviceFont(20, 370, ENG_16X25, 1, 1, ROTATE_0, false, '463-400, KOREA');

      PrintDeviceFont(26, 421, ENG_12X20, 1, 1, ROTATE_0, false, 'POSTAL CODE');
      PrintDeviceFont(503, 798, ENG_12X20, 1, 1, ROTATE_0, false, 'DESTINATION');
      PrintDeviceFont(42, 841, ENG_32X50, 1, 1, ROTATE_0, true, '30 Kg');
      PrintDeviceFont(25, 798, ENG_12X20, 1, 1, ROTATE_0, false, 'WEIGHT:');
      PrintDeviceFont(259, 798, ENG_12X20, 1, 1, ROTATE_0, false, 'DELIVERY NO:');
      PrintDeviceFont(23, 630, ENG_12X20, 1, 1, ROTATE_0, false, 'AWB:');
      PrintDeviceFont(274, 841, ENG_32X50, 1, 1, ROTATE_0, true, '425518');
      PrintDeviceFont(104, 627, ENG_19X30, 1, 1, ROTATE_0, false, '8741493121');
      PrintDeviceFont(565, 841, ENG_32X50, 1, 1, ROTATE_0, true, 'ICN');

      //	Prints 1D Barcodes
      Print1DBarcode(69, 458, CODE39, 4, 8, 137, ROTATE_0, true, '1234567890');
      Print1DBarcode(127, 662, CODE93, 4, 8, 90, ROTATE_0, true, '8741493121');

      //	Prints a MAXICODE
      Direct_MaxiCode_2DBarcode_Cmd := 'B2555,180,M,0,''999,840,06810,7317,BIXOLON LABEL PRINTER''';
      PrintDirect(Direct_MaxiCode_2DBarcode_Cmd);//

      //	Prints a PDF417
      Direct_PDF_2DBarcocde_Cmd := 'B2200,945,P,8,8,0,0,0,1,2,14,0,''BIXOLON Label Printer, This is for test.''';
      PrintDirect(Direct_PDF_2DBarcocde_Cmd);//

      PrintCircle(10, 1055, 3, 2);


      // Prints a QRCode
      //  P1 : Horizontal position (X) [dot]
      //  P2 : Vertical position (Y) [dot]
      //  P3 : MODEL selection (1, 2)
      //  P4 : ECC Level (1 ~ 4)
      //  P5 : Size of QRCode (1 ~ 4)
      //  P6 : Rotation (0 ~ 3)
      //  P7 : data to print
      QRCode_data := 'QRCode sample test 123';//"家裸多羅馬바 123";//가나다라마바사아자차카타파하";// "QRCode with UTF-8 Encoding";
      PrintQRCode(22, 940, QRMODEL_2, QRECCLEVEL_M, QRSIZE_4, ROTATE_0, QRCode_data);

      // Print Image
      PrintImageLib(200, 1035, 'free.bmp', DITHER_1, false);
      PrintImageLib(450, 1035, 'BIXOLON.bmp', DITHER_2, false);

      //	Print Command
      Prints(1, 1);

      //	Set the Label End
      EndLabel();

      //	Disconnect Printer Driver
      DisconnectPrinter();

    end // connect ok

    else begin
      MessageBox(0, 'Connect fail', 'BIXOLON', MB_OK);
    end; // connect fail

  except
    MessageBox(0, 'Invalid some input parameters' + #13 + #10 + 
    '( Paper size? or Margins? ...)', 'BIXOLON', MB_OK+MB_IConError);
  end; // end try

end; // end btnPrintLabelClick

end.
// FORM END
