/*********************************************************************************************
 Note:
 This file is for generic, common, non page specific functions.  If you are creating
 a function specific to a page it should go in the page specific javascript file.
*********************************************************************************************/

//only load the util broker once even for framesets
if(!top.document.UtilBroker)
{
	top.document.UtilBroker = Components.classes["component://netscape/utilitybroker"].createInstance();
	top.document.UtilBroker = top.document.UtilBroker.QueryInterface(Components.interfaces.hpIUtilityBroker);
}

var UtilBroker=top.document.UtilBroker;

if(top.document.debug==null)
	top.document.debug=GetMacroValue("DISPLAY_MODE");


function PrintButtonSupport()
{
	switch(GetMacroValue("LANG").toLowerCase())
	{
		//case "chs":
		//case "cht":
		case "jpn":
		//case "kor":
			if(ProcessSysInfoItem("WindowsVersion").match("Microsoft Windows 95"))
			{
				var swoosh=null;

				if(top.frames && top.frames.length)
				{
					DisplayElement("div:footPrintButton","hidden");
					DisplayElement("div:footPrintLabel","hidden");
					swoosh=GetElementFromPath("div:footerbackground,img")
				}
				else
				{
					DisplayElement("div:printButton","hidden");
					DisplayElement("div:printLabel","hidden");
					swoosh=GetElementFromPath("div:swoosh,img")
				}

				if(swoosh)
					swoosh.setAttribute("src",swoosh.getAttribute("src").replace(/\.gif/,"-np.gif"));
			}
			break;
	}
}

function PrintDemoPage()
{	
	var InstallBroker = Components.classes["@dugout/infield/instservice;1"].getService(Components.interfaces.IInstService);
    	InstallBroker.InitProcess( null, true );
    
   	// get product
	var product=GetMacroValue("PROD");
    	InstallBroker.SetProcessString( "product", product);
    
    	// get lang
    	InstallBroker.SetProcessString( "lang", GetMacroValue("LANG"));

    	// get location of install root and master.hpi file
    	var infieldRoot=GetMacroValue("INFIELD_DIR") + "\\";
    
    	// sample is in dugout path + product subdir
	var strDugoutPath=GetMacroValue("INSTALLDIR") + "\\" + product + "\\";

	var isSleek=GetMacroValue("SLEEK");
	
	if (isSleek=="true")
	{
		// make the name of the print sample file a macro for the installer for sleek products
   		InstallBroker.SetProcessString( "print_sample_file", strDugoutPath + "sample" + PrintDemoPage.arguments[0] + ".ldl" );
	}
	else
	{
   		// make the name of the print sample file a macro for the installer for non-sleek products
   		InstallBroker.SetProcessString( "print_sample_file", strDugoutPath + "sample" + PrintDemoPage.arguments[0] + ".pcl" );
	}

  	InstallBroker.Process( infieldRoot + "master.hpi", "print_demopage");    
}

function ProcessSysInfoItem(SysInfoItem)
{
	var retStr="Unknown";

	switch(SysInfoItem)
	{
		case "PrinterMdl":
			retStr=GetMacroValue("MODEL");
			break;

		case "PrinterAssistantVersion":
			retStr=GetMacroValue("UPDATE");
			if(retStr)
				retStr=GetMacroValue("VERSION") + " / " + retStr;
			else
				retStr=GetMacroValue("VERSION") + " / " + "0.0";
			break;

		case "MfgInfo":
			retStr=GetMacroValue("MFG");
			if(retStr=="")
				retStr="Hewlett Packard"
			break;

		case "DrvVersion":
			retStr=ProcessSysInfoItem("PrinterInfoBasic");
			retStr=retStr.match(/Drv\s*=\s*[^,]+/);
			retStr=retStr[0].match(/[\d\.]+$/);
			retStr=retStr[0];
			break;

		default:
			retStr=GetExpandValue("$SystemInfo," + SysInfoItem + "$");
			break;
	}

	return retStr;
}

// Turns background window on behind dugout
function EnableBackground()
{
	return GetExpandValue("$EnableBackground,true,0x996600$")
}

// Turns background window off behind dugout
function DisableBackground()
{
	return GetExpandValue("$EnableBackground,false,0$")
}

function LogMessage()
{
	var verbosity="2";
	var message="";
	if(LogMessage.arguments.length > 1)
	{
		verbosity=LogMessage.arguments[0];
		message=LogMessage.arguments[1];
	}
	else
		message=LogMessage.arguments[0];

	message=message.replace(/%/g,"%%");

	UtilBroker.HPLogMessage(verbosity,message);
}

function GetExpandValue(macro)
{
    var outString = new Object();
	var returnValue=new Object();

	UtilBroker.HPExpandString(macro,outString,returnValue);
	return outString.value;
}

function GetMacroValue(macroName)
{
    var outString = new Object();
	UtilBroker.HPGetMacro(macroName,outString);
	return outString.value;
}

//function handles more efficient Swapping and restoring images
//params:
//	obj - top-level element containing image - will traverse to image element
//	imgId - optional, either image name or index - default is 0
//	newImgSrc - optional, new image src value.  If omitted tries to restore last image
// Ex)
//	SwapImageEx(this,'purpleBtn','Images/purpleButton2') - swaps the purpleBtn IMG elements image with "Images/purpleButton2"
//	SwapImageEx(this) - restores first IMG src to original value
function SwapImageEx(obj,imgId,newImgSrc) 
{
	var retval=0;
	if(typeof(obj) == "string")
		obj=GetElementFromPath(obj)

	if(!imgId)
		imgId=0

	if(obj && typeof(obj)=="object")
	{
		var imgs=obj.getElementsByTagName("IMG");
		var imgObj,lastImgSrc=null;

		if(imgs && imgs[imgId])
			imgObj=imgs[imgId]
		else if(obj.hasChildNodes())
		{
			for(var i=0;i<obj.childNodes.length;i++)
			{
				retval=SwapImageEx(obj.childNodes[i],imgId,newImgSrc);
				if(retval)
					break;
			}
		}

		if(!retval && imgObj)
		{
			if(newImgSrc)
			{
				if(imgObj.getAttribute("src")!=newImgSrc)
				{
					imgObj.lastImgSrc=imgObj.getAttribute("src");
					imgObj.setAttribute("src",newImgSrc);
				}
			}
			else if(imgObj.lastImgSrc)
			{
				imgObj.setAttribute("src",imgObj.lastImgSrc);
				imgObj.lastImgSrc=null;
			}		
				
			retval=1;
		}
	}

	return retval;
}

function PreloadImages()
{
    var imgFiles = PreloadImages.arguments;
    if (top.document.preloadArray==null)
        top.document.preloadArray = new Array();

    var i = top.document.preloadArray.length;
    with(top.document)
    {
        for (var j=0; j<imgFiles.length; j++)
        {
            preloadArray[i] = new Image;
            preloadArray[i++].src = "images/" + imgFiles[j];
        }
    }
}

function BackButton()
{
	if(!top.document.URL.match(/\?no-back/))
		top.back()
}

function exitButton(forceExit)
{
	if(!forceExit && GetMacroValue("GETBACK") == 1)
	{ 
		var strIsPreload = new Object();
		
		top.location = "dugout_get_back.html"
		UtilBroker.HPSetMacro("GETBACK","0");

		var InstallBroker = Components.classes["@dugout/infield/instservice;1"].getService(Components.interfaces.IInstService);
        InstallBroker.GetProcessString( "hpistr.hpi", "preload", strIsPreload );
        
        if(strIsPreload.value != "true")
			DisableBackground();
	}
	else
		GetExpandValue("$CloseApp$")
}

function PrintCurrentPage()
{
	LogMessage("-- Printing Current Page --")
	var frameIndex=null;

	//see if a frame is specified and add it to the macro
	if(PrintCurrentPage.arguments[0])
		frameIndex="," + PrintCurrentPage.arguments[0] + "$";
	else
		frameIndex="$";

	GetExpandValue("$PrintCurrentPage" + frameIndex);
}

function LoadJumpURL(actionStr,mfgStr,passThruParams)
{
	LogMessage("Jumpstation: action=" + actionStr + " mfg=" + (mfgStr?mfgStr:"default"))
	// assume first parameter is the action and if 
	// there is a second parameter that it is the manufacturer
	var retVal=new Object();
	var prodStr = GetMacroValue("PROD");
	var langStr = new Object();
	langStr.value=GetMacroValue("LANG");

	if(JumpstationSupportsLang(actionStr,langStr))
	{
		var serverStr=GetMacroValue("JUMPSERVER");

		if(serverStr == "")
			serverStr="hpdjjs.com"

		//set manufacturer if none specified
		if(!mfgStr || mfgStr == "")
		{
			mfgStr=GetMacroValue("MFG");

			if(mfgStr == "")
				mfgStr = "HP";
		}

		//create new URL
		var JumpStationURL="http://" + serverStr + "/jumpstation?action=" + actionStr + "&mfg=" + mfgStr + "&lang=" + langStr.value + "&product=" + prodStr;

		if(passThruParams)
			JumpStationURL+=passThruParams;

		//convert white spaces to '+' to be valid in a URL and then load the URL
		LoadOutsideURL(JumpStationURL.replace(/\s+/,"+"));
	}
	else
		top.location = "warn_notavailable_support.html";
}

function LoadOutsideURL()
{ 
	//first see if there is a default browser
	var errorPage=true;

	if(GetExpandValue("$DefaultBrowser$") != "")
	{
		//check to see if they are connected to the Internet
		if(GetExpandValue("$InetConnectionStatus$") != "")
		{
			//launch browser with URL
			GetExpandValue("$run," + LoadOutsideURL.arguments[0] + "$");
			errorPage=false;
		}
	}

	if(errorPage)
		top.location.href = "warn_connect_error.html";
}

function JumpstationSupportsLang(action,lang)
{
	var retVal=0;
	switch(action.toLowerCase())
	{
		case "supportweb":
			switch(lang.value)
			{
				case "enu":
				case "fra":
				case "esm":
				case "ptb":
				case "deu":
				case "svc":
				case "kor":
				case "chs":
				case "cht":
				case "jpn":
					retVal=1;
					break;
			}
			break;

		case "supportforum":
			break;

		case "supportemail":
			switch(lang.value)
			{
				case "enu":
				case "kor":
				case "cht":
				case "jpn":
					retVal=1;
					break;					
			}
			break;

		case "printingideas":
		case "buyink":
		case "buymedia":
		case "buyaccess":
		case "buyhp":
		case "lowink":
			lang.value=lang.value + "&langid=0x" + ProcessSysInfoItem("LanguageID");
			retVal=1;
			break;

		case "homeoffice":	 //legacy
		case "mozilla":
		case "mozillampl":
		case "mozillacredits":
		case "regionalsupport":
		case "extwarrantyloc":
		case "techsupport":
		default:
			retVal=1;
			break;
	}

	return retVal;
}

//param:
//	path - path expression identifiying path to element to be removed
//	Ex)
//	   div:button1,span:5,p - removes the first p element from the 5th span element of the div element named button1
function GetElementFromPath(path)
{
	var pathArray=path.split(",")
	var pathEntry=null;
	var elementObj=document;

	for(var i=0;i<pathArray.length;i++)
	{
		pathEntry=pathArray[i].split(":")
		if(pathEntry.length==1)
			elementObj=elementObj.getElementsByTagName(pathEntry[0]).item(0)
		else if(pathEntry[1].match(/\b\d+\b/))
			elementObj=elementObj.getElementsByTagName(pathEntry[0]).item(parseInt(pathEntry[1]))
		else
		{
			elementObj=elementObj.getElementsByTagName(pathEntry[0])
			elementObj=elementObj[pathEntry[1]]
		}

		if(!elementObj)
			break;
	}

	return elementObj;
}

function DisplayElement(path,visibilityVal)
{
	var elementObj=GetElementFromPath(path);

	if(elementObj)
	{
		if(!visibilityVal.match(/hidden|collapse/i))
		{
			var elementStyle=elementObj.getAttribute("style")

			if(elementStyle == "")
				elementObj.setAttribute("style","visibility:" + visibilityVal)
			else if(elementStyle.match(/visibility\s*:\s*/i))
			{
				elementStyle=elementStyle.replace(/visibility\s*:\s*\w+/i,"visibility:" + visibilityVal);
				elementObj.setAttribute("style",elementStyle)
			}
			else
				elementObj.setAttribute("style",elementStyle + "; visibility:" + visibilityVal)
		}
		else if(!top.document.debug)
			elementObj.parentNode.removeChild(elementObj);
	}
}

function EmitDOM(node,indent,mode,filename)
{
	var skipChildNodes=false;
	var skipEndTag=false;
	var skipIndent=false;
	var resultStr="";
	var modeParam=mode?mode.replace(/^(create|new|append|debug),?/i,""):mode;
	if(indent==null)
		indent="";

	if(node==null)
		node=document.documentElement;

	if(node.nodeType==1)
	{
		var emitScriptTag=true;
		if(modeParam.match(/(clean)/i) && !node.getAttribute("src"))
			emitScriptTag=false

		if(modeParam.match(/(noscript)/i))
			emitScriptTag=false;

		if(!mode || !node.nodeName.match(/^script$/i) || emitScriptTag)
		{
			resultStr=indent + "<" + node.nodeName.toUpperCase();

			if(node.attributes)
			{
				for(var i=0;i<node.attributes.length;i++)
				{
					var caseDone=false;
					var matchStr=node.attributes.item(i).nodeName.toLowerCase();

					if(modeParam.match(/(noscript)/i) && matchStr.match(/^(on)/i))
						matchStr="on";

					switch(matchStr)
					{
						case "on":
							break;

						case "src":
							if(!caseDone)
							{
								if(node.nodeName.match(/^img$/i) && modeParam.match(/img-prefix\s*=\s*([^,]+)/i))
									resultStr+=" " + node.attributes.item(i).nodeName + '="' + RegExp.$1 + node.attributes.item(i).nodeValue +'"';
								else if(node.nodeName.match(/^frame$/i) && !node.attributes.item(i).nodeValue.match(/header|footer/i) && modeParam.match(/fssrc\s*=\s*([^,]+)/i))
									resultStr+=" " + node.attributes.item(i).nodeName + '="' + RegExp.$1 + '"';
								else
									resultStr+=" " + node.attributes.item(i).nodeName + '="' + node.attributes.item(i).nodeValue +'"';
								break;
							}

						case "href":
							if(!caseDone && modeParam.match(/nolink/i) && node.nodeName.match(/^a$/i))
							{
								resultStr+=" " + node.attributes.item(i).nodeName + '="javascript:void(\'\')"';
								break;
							}

						default:
							if(node.attributes.item(i).nodeName.match(/^\w/))
								resultStr+=" " + node.attributes.item(i).nodeName + '="' + node.attributes.item(i).nodeValue + '"';
							break;
					}
				}
			}

			if(node.nodeName.match(/^(area|base(font)?|br|col|frame|hr|img|input|isindex|keygen|link|meta|param|plaintext|spacer|wbr)$/i))
			{
				skipEndTag=true;
				resultStr += "/>";
			}
			else
				resultStr += ">";

			if(node.nodeName.match(/^(textarea|button)$/i))
				skipIndent=true;
			else
				resultStr += "\r\n";
		}
		else
		{
			skipEndTag=true;
			skipChildNodes=true;
		}
	}
	else if(node.nodeType==3)
	{
		if(node.data.match(/[^\s]/))
		{
			var text=node.data.replace(/\s+/g," ");
			if(indent)
				resultStr=indent + text + "\r\n";
			else
				resultStr=text;
		}
	}

	if(node.childNodes && !skipChildNodes)
	{
		for(var i=0;i < node.childNodes.length;i++)
			resultStr+=EmitDOM(node.childNodes.item(i),skipIndent?"":indent+"\t",modeParam)
	}

	if(!skipEndTag && node.nodeType==1)
		resultStr+= ((skipIndent?"":indent) + "</" + node.nodeName.toUpperCase() + ">\r\n")

	if(mode.match(/^(create|new|append|debug),?/i))
	{
		mode=RegExp.$1;
		var charset;
		switch(GetMacroValue("LANG").toLowerCase())
		{
			case "chs":charset="gb2312";break;
			case "cht":charset="Big5";break;
			case "jpn":charset="Shift_JIS";break;
			case "kor":charset="EUC-KR";break;
			case "rus":charset="Windows-1251";break;
			case "csy":
			case "hun":
			case "plk":charset="Windows-1250";break;
			case "tha":charset="Windows-874";break;
			default:charset="iso-8859-1";break;
		}

		if(!mode.match(/debug/i) && !filename)
		{
			filename=String(node.ownerDocument.location);
			filename=filename.replace(/^[^\/]+[\/]+/,"");
			filename=filename.replace(/\|/,":");
			filename=filename.replace(/?.*$/,"");
			filename=unescape(filename);
			if(modeParam.match(/id=([^,]+)/i))
			{
				id=RegExp.$1;
				filename=filename.replace(/.htm/i,"-"+id+".htm");
			}

			CheckScrollBars(node,filename);
		}

		UtilBroker.HPWriteDOM('<!--?xml version="1.0" encoding="' + charset + '"?-->\r\n' + resultStr,mode,filename?filename:"");

		if(top.frames && top.frames.length && !modeParam.match(/fssrc=/i) && modeParam.match(/(all|id=)/i))
		{
			var param=RegExp.$1;
			var fssrc=filename.match(/([^\/\\]+)$/i)
			if(fssrc)
				fssrc=RegExp.$1;
			else
				fssrc=filename

			modeParam=modeParam.replace(/all,?/i,"");
			EmitDOM(top.document.documentElement,null,mode + "," + modeParam + ",fssrc=" + fssrc)
			modeParam=modeParam.replace(/id=[^,]+,?/i,"");
			for(var i=0;param=="all" && i<top.frames.length;i++)
			{
				if(top.frames[i].document != node.ownerDocument)
					EmitDOM(top.frames[i].document.documentElement,null,mode + "," + modeParam)
			}
		}		
	}
	else
		return resultStr;
}


function CheckScrollBars(node,filename)
{
	if(node==null)
		node=document.documentElement;

	if(!filename)
	{
		filename=String(node.ownerDocument.location);
		filename=filename.replace(/^[^\/]+[\/]+/,"");
		filename=filename.replace(/\|/,":");
		filename=unescape(filename);
		filename=unescape(filename);
	}

	if(filename.match(/([^\/\\]+)$/))
		filename=RegExp.$1	

	var win=FindWindow(top,node.ownerDocument);
	var xpos=win.pageXOffset;
	var ypos=win.pageYOffset;

	win.scrollBy(1,0);
	if(win.pageXOffset > xpos)
		LogMessage(0,"WARNING -> Horizontal Scrollbars: " + filename)

	if(!top.frames || !top.frames.length || (top.frames[1].document != node.ownerDocument))
	{
		win.scrollBy(0,1);
		if(win.pageYOffset > ypos)
			LogMessage(0,"WARNING -> Vertical Scrollbars: " + filename)
	}

	win.scrollTo(xpos,ypos);
}
//*********************************************************************************************
// ====================================
// Accessiblity Support Module
// ====================================
var tabPressMutexValue=1
var enterPressMutexValue=2
var homePressMutexValue=4
var endPressMutexValue=8
var downArrowPressMutexValue=16
var upArrowPressMutexValue=32
var currLang=null

LoadAccessibilityModule()

function LoadAccessibilityModule(mode)
{
	//ensure accessibility is loaded from main frame if it exists
	if(!top.frames || !top.frames.length || top.frames[2].document==document)
	{
		if(!top.document.focusStack || (mode && mode=="reset"))
		{
			if(mode==null || mode!="reset")
			{
				LogMessage("Initializing Accessibility!!!")
				SetWindowFilters(top,"init")
			}

			if(!currLang)
			{
				var lang = new Object();
				UtilBroker.HPGetMacro("LANG",lang);
				currLang=lang.value
			}

			top.document.focusStack = new Array()
			SetWindowFilters(top,"filter")
			LoadFocalIndex()
			top.document.modifiers=0;
			top.document.mutex=0;
			top.focus()
		}
	}
}

function LoadFocalIndex(mode)
{
	if(mode=="index" || mode=="index|screen-read")
	{
		if(top.document.focusTable==null)
		{
			top.document.tempTable=new Array();
			top.document.indexTable=new Array();
			top.document.indexTable.numItems=0;

			if(top.document.tempTable && top.document.indexTable)
				FocalIndexer(top,mode)

			if(top.document.indexTable.length || top.document.tempTable.length)
			{
				LogMessage("Initializing FocusTable")
				top.document.focusTable=new Array();
				top.document.focusTable.currentIndex=0
				var extent=top.document.indexTable.numItems + top.document.tempTable.length
				var j=0,k=0

				for(var i=0;i<extent;i++)
				{
					if(top.document.indexTable[i] || !top.document.tempTable[j])
					{
						if(top.document.indexTable.numItems)
						{
							if(top.document.indexTable[i] && top.document.tempTable[j])
							{
								top.document.focusTable[i]=top.document.indexTable[i]
								k=i+1
							}
							else
							{
								var loop=1
								if(k < i)
									k=i

								do
								{
									if(top.document.indexTable[k])
									{
										top.document.focusTable[i]=top.document.indexTable[k]
										loop=0
									}
									k++
								}while(loop)
							}

							top.document.indexTable.numItems--
						}
					}
					else
					{
						top.document.focusTable[i]=top.document.tempTable[j]
						j++
					}
				}

				top.document.focusTable.mode="init"

				if(LoadFocalIndex.arguments.length > 1)
					top.document.focusTable.currentIndex=LoadFocalIndex.arguments[1];
				else if(top.document.index)
					top.document.focusTable.currentIndex=top.document.index;

				if(mode=="index")
					FindNextIndexedFocus();
				else if(top.frames.length)
				{
					top.document.focusTable.mode="index"
					FindNextIndexedFocus();					
				}
			}

			delete top.document.tempTable
			delete top.document.indexTable
			delete top.document.index			
		}
		else if(top.document.screenReaderText==null)
			FocalIndexer(top,mode)
	}
	else if(mode == "reset")
	{
		if(top.document.index)
			delete top.document.index;

		if(top.document.focusTable)
		{
		 	delete top.document.focusTable;
			delete top.document.currentWin;
			delete top.document.focusStack
		}

		if(top.document.screenReaderText)
		{
			delete top.document.screenReaderText;
			delete top.document.screenReaderIndex;
		}

		SetWindowFilters(top,"releaseall")
		LoadAccessibilityModule(mode)
	}
	else
	{
		if(LoadFocalIndex.arguments[0])
			top.document.index=LoadFocalIndex.arguments[0]
		else
			top.document.index=0
	}
}

function FocalIndexer(win,mode)
{
	var count=null;
	if(top.document.tempTable && top.document.indexTable)
		count=top.document.tempTable.length + top.document.indexTable.length
	DocFocalIndexer(win.document,mode,false)
	if((count!=null) && count==(top.document.tempTable.length + top.document.indexTable.length))
		top.document.tempTable[top.document.tempTable.length]=win

	if(win.frames.length)
	{
		for(var i=0;i<win.frames.length;i++)
			FocalIndexer(win.frames[i],mode)
	}
}

function DocFocalIndexer(node,mode,extractText)
{
	if((top.document.focusTable==null) && ValidFocalNode(node))
	{
		var tabindex=node.getAttribute("tabindex")
		if(tabindex != "")
		{
			tabindex=parseInt(tabindex)
			if(top.document.indexTable[tabindex])
				LogMessage("WARNING: Over Writing Existing Index!!!")
			else
				top.document.indexTable.numItems++

			top.document.indexTable[tabindex]=node
		}
		else
			top.document.tempTable[top.document.tempTable.length]=node
	}

	if((mode=="index|screen-read") && node.nodeType==Node.ELEMENT_NODE)
	{
		var classData=node.getAttribute("class");

		if(classData)
		{
			switch(classData)
			{
				case "buttonLabels": 
				case "GroupTitlesIX": 
				case "Level1IX": 
				case "Level2IX": 
				case "Level3IX": 
				case "Level4IX": 
					extractText=false;
					break;

				default:
					if(!extractText && top.document.screenReaderText)
					{
						if(top.document.screenReaderText[top.document.screenReaderText.length-1]!="\n")
							top.document.screenReaderText=top.document.screenReaderText+"\n"
					}

					extractText=true;
					break;
			}
		}
        else if(node.nodeName.match(/^(table|tr)$/i))
			extractText=false;
	}
	else if(extractText && node.nodeType==Node.TEXT_NODE && !node.parentNode.nodeName.match(/^script$/i))
	{
		var text=node.data.replace(/\s{2,}/g," ")
		text=text.replace(/^\s+|\s+$/,"")

		if(text)
		{
			if(top.document.screenReaderText)
				top.document.screenReaderText=top.document.screenReaderText + " " + text
			else
			{
				top.document.screenReaderText=text
				top.document.screenReaderIndex=0
			}
		}
	}

	if(node.childNodes)
	{
		for(var i=0;i < node.childNodes.length;i++)
		{
			if(node.nodeType!=Node.ELEMENT_NODE || 
			   !(node.getAttribute("style").match(/hidden/i) || node.getAttribute("style").match(/collapse/i)))
				DocFocalIndexer(node.childNodes[i],mode,extractText)
		}
	}
}

function FindNextIndexedFocus(mode,param)
{
	if(top.document.focusTable)
	{
		CheckFocusDisplay(top.document.focusTable[top.document.focusTable.currentIndex],"blur")
		var loop=1
		var current=top.document.focusTable.currentIndex
		var node=null

		if(top.document.focusTable.mode)
		{
			mode=top.document.focusTable.mode;
			param=current;
			delete top.document.focusTable.mode;
		}

		do
		{
			top.document.focusTable.currentIndex=nextIndex()
			node=top.document.focusTable[top.document.focusTable.currentIndex]

			if(node)
			{
				loop=0
				switch(mode)
				{
					case "init":
						if((top.document.modifiers & Event.SHIFT_MASK) || 
							(top.document.focusTable[param].toString()=="[object Window]"))
							mode="nextElement"
						else
						{
							top.document.focusTable.currentIndex=param
							node=top.document.focusTable[param]
							break;
						}

					case "nextElement":
						if(node.toString()=="[object Window]")
							loop=1;
						break;

					case "match":
						if(node.toString()=="[object Window]" ||
						  (param && param!=node.getAttribute("name") &&
						  param!=node.localLink))
							loop=1
						break;

					case "index":
						if(top.document.focusTable.currentIndex !=param)
							loop=1
						break;

					case "object":
						if(param && top.document.focusTable[top.document.focusTable.currentIndex]!=param)
							loop=1									
						break;

					case "winobj":
						{
							var next=top.document.focusTable[nextIndex()]

							if((next.toString()=="[object Window]" && next!=param) ||
								(FindWindow(top,next.ownerDocument) != param))
								loop=1
						}
						break;

					case "next":
					default:
						break;
				}

				if(mode != "winobj")
				{
					if(node.toString()!="[object Window]" && 
						FindWindow(top,node.ownerDocument) != top.document.currentWin)
						SetWindowFilters(FindWindow(top,node.ownerDocument),"filter")

					if(!loop)
					{							
						if(node.toString()=="[object Window]")
							SetWindowFilters(top.document.focusTable[top.document.focusTable.currentIndex],"filter")
						else
						{
							if(top.document.focusTable[current].nodeName!="A")
								top.document.focusTable[current].blur();

							if(node.nodeName != "A")
								node.focus();

						  	CheckFocusDisplay(node,"focus")
						}
					}
				}
			}
		}while(loop && current!=top.document.focusTable.currentIndex)
	}
}

function ValidFocalNode(node,match)
{
	var retval=0
	if(node.nodeType==Node.ELEMENT_NODE)
	{
		if(node.getAttribute("tabindex")!="")
		{
			var tabindex=node.getAttribute("tabindex")	  
			if(tabindex != "OFF")
			{
				if(!tabindex.match(/\d+/) || parseInt(tabindex) > 500)
					node.removeAttribute("tabindex")

				retval=1
			}
		}
		else if(node.getAttribute("style").match(/hidden/i))
		  	retval=0
		else
		{
			switch(node.nodeName)
			{
				case "A":
					if(match && match==node.getAttribute("name"))
						retval=1
					else if(node.getAttribute("href") || node.getAttribute("onclick") || node.getAttribute("ondblclick") ||
					   		node.getAttribute("onkeyup") || node.getAttribute("onkeypress") || node.onclick ||
					   		node.ondblclick || node.onkeyup || node.onkeypress)
					{
						if(ValidFocalNode.localLink)
						{
							node.localLink=ValidFocalNode.localLink
							delete ValidFocalNode.localLink
						}

						retval=1
					}
					else if(node.getAttribute("name"))
						ValidFocalNode.localLink=node.getAttribute("name")
					break;

				case "SELECT":
					{
						var onchange=node.getAttribute("onchange")
						if(onchange)
							onchange=onchange + ";FindNextIndexedFocus('object',this)"
						else
							onchange="FindNextIndexedFocus('object',this)"

						node.setAttribute("onchange",onchange);
					}
				case "INPUT":
				case "BUTTON":
					if(!match)
						retval=1
					break;
			}
		}
	}

	return retval
}

function CheckFocusDisplay(node,mode)
{
	if(node && node.nodeType==Node.ELEMENT_NODE && !node.getAttribute("onfocus"))
	{
		var orgnode=node
		var type=null;

		switch(node.nodeName)
		{
			case "SELECT": 
				if(mode=="focus")
				{
					type=" $listbox$ " + orgnode.value;
					var alttext=null
					if(orgnode.getAttribute("alt"))
						alttext=orgnode.getAttribute("alt") + type;

					if(alttext!="")
						SetScreenReaderText(alttext);
					break;
				}

			case "INPUT":
				if(mode=="focus")
				{
					var alttext= ""
					switch(orgnode.getAttribute("type"))
					{
						case "radio":
						case "checkbox":
							type=" $" + orgnode.getAttribute("type")  + "$ $" + (orgnode.checked?"checked":"!checked") + "$";
							break;

						case "button":
							type=orgnode.value + " $button$"
							break;

						case "file":
							break;

						default:
							type=orgnode.value + " $edit$"
							break;
					}

					if(orgnode.parentNode.getAttribute("alt"))
						alttext=orgnode.parentNode.getAttribute("alt")

					alttext=alttext + "\n" +  orgnode.getAttribute("alt") + type;

					if(alttext!="")
						SetScreenReaderText(alttext);
				}
				else if(mode=="blur")
					SetScreenReaderText("$NULL$");
				break;

			case "BUTTON":
				type=" $button$"
			default:
				if(type==null)
				{
					if(node.getElementsByTagName("IMG").item(0))
					{
						node=node.getElementsByTagName("IMG").item(0)
						type=" $button$"
					}
					else
						type=" $link$"
				}

				if(mode=="focus")
				{
					var style=node.getAttribute("style")
					if(style)
					{
						node.oldStyle=style
						style=style + ";"
					}

					style=style + "border-style: dotted; border-width:1px;"
					node.setAttribute("style",style)

					if(orgnode.getAttribute("alt") || orgnode.hasChildNodes())
					{
						var alttext= ""

						if(orgnode.getAttribute("alt"))
							alttext=orgnode.getAttribute("alt") + type
						else
						{
							orgnode.normalize()
							for(var i=0;i < orgnode.childNodes.length;i++)
							{
								if(orgnode.childNodes[i].nodeType==Node.TEXT_NODE)
								{
									var text=orgnode.childNodes[i].data.replace(/^\s+/,"")
									if(text!="")
										alttext=text + type
									break
								}
							}
						}

						if(alttext!="")
							SetScreenReaderText(alttext);
					}
				}
				else if(mode=="blur")
				{
					if(node.oldStyle)
					{
						node.setAttribute("style",node.oldStyle)
						delete node.oldStyle
					}
					else
						node.removeAttribute("style")

					SetScreenReaderText("$NULL$");
				}
			break;
		}
	}
}

function SetScreenReaderText(text)
{
	switch(currLang.toLowerCase())
	{
		case "enu":
		case "esm":
		case "fra":
		case "deu":
		case "ita":
		case "ptb":
			text=text.replace(/[ \t\f]+/g," ")
			//dump("\nscreenreader:" + text);
			UtilBroker.HPSetWindowText(text);
			break;
	}
}

function nextIndex(mode)
{
	var index=top.document.focusTable.currentIndex

	if(mode=="previous" || top.document.modifiers & Event.SHIFT_MASK)
	{			
		if(index <=0)
			index=top.document.focusTable.length

		index--
	}
	else //mode=="next"
	{
		index++
		if(index >= top.document.focusTable.length)
			index=0
	}

	return index
}

function peekFS()
{
	var retval=null
	if(top.document.focusStack!=null && top.document.focusStack.length)
		retval=top.document.focusStack[top.document.focusStack.length-1]

	return retval
}

function EventFilter(evt)
{
	var routeEvt=1

	switch(evt.type)
	{
		case "keydown":
			switch(evt.which)
			{
				case 9:	 //tab
					if(!(top.document.mutex & tabPressMutexValue))
					{
						top.document.mutex=top.document.mutex | tabPressMutexValue

						if(top.document.focusTable==null)
							LoadFocalIndex("index")
						else
							FindNextIndexedFocus("next")
					}
					routeEvt=0;
					break;

				case 13: //enter
					if(!(top.document.mutex & enterPressMutexValue))
						top.document.mutex=top.document.mutex | enterPressMutexValue
					break;

				case 16: //shift
					top.document.modifiers = top.document.modifiers | Event.SHIFT_MASK;
					break;

				case 17: //ctrl
					top.document.modifiers = top.document.modifiers | Event.CONTROL_MASK;
					break;

				case 18: //alt
					top.document.modifiers = top.document.modifiers | Event.ALT_MASK;
					break;

				case 33: //page up
					top.document.currentWin.scrollBy(0,-top.document.currentWin.innerHeight)
					break;

				case 34: //page down
					top.document.currentWin.scrollBy(0,top.document.currentWin.innerHeight)
					break;

				case 35: //end
					if(!(top.document.mutex & endPressMutexValue))
						top.document.mutex=top.document.mutex | endPressMutexValue
					if(!top.document.modifiers)
					{
						var lastOffset
						do
						{
							lastOffset=top.document.currentWin.pageYOffset
							top.document.currentWin.scrollBy(0,top.document.currentWin.innerHeight)
						}while(top.document.currentWin.pageYOffset != lastOffset)
					}
					break;

				case 36: //home
					if(!(top.document.mutex & homePressMutexValue))
						top.document.mutex=top.document.mutex | homePressMutexValue
					if(!top.document.modifiers)
						top.document.currentWin.scrollTo(0,0)
					break;

				case 37: //left arrow
					top.document.currentWin.scrollBy(-25,0)
					break;

				case 38: //up arrow
					if(!(top.document.mutex & upArrowPressMutexValue))
						top.document.mutex=top.document.mutex | upArrowPressMutexValue
					if(!top.document.modifiers)
						top.document.currentWin.scrollBy(0,-25)
					break;

				case 39: //right arrow
					top.document.currentWin.scrollBy(25,0)
					break;

				case 40: //down arrow
					if(!(top.document.mutex & downArrowPressMutexValue))
						top.document.mutex=top.document.mutex | downArrowPressMutexValue
					if(!top.document.modifiers)
						top.document.currentWin.scrollBy(0,25)
					break;
			}
			break;
		case "keyup":		
			switch(evt.which)
			{
				case 9:  //tab
					if(top.document.mutex & tabPressMutexValue)
					{
						if(top.document.focusTable)
						{
							var node=top.document.focusTable[top.document.focusTable.currentIndex]
						 	if(node && node.nodeType==Node.ELEMENT_NODE)
							{
								node.focus()
								if(node.nodeName=="A")
									node.blur()
							}
						}
				  		else if(peekFS())
					  	{
					  		var current=peekFS()
							if(current.nodeType == Node.ELEMENT_NODE)
						  		current.focus()
						}
						top.document.mutex=top.document.mutex-tabPressMutexValue
					}
					break;

				case 13: //enter
					if(top.document.mutex & enterPressMutexValue)
					{
				  		var current=top.document.focusTable?top.document.focusTable[top.document.focusTable.currentIndex]:peekFS()
						if(current)
						{							
							var cmd=current.getAttribute("onclick");
							var href=current.getAttribute("href");

							if(href)
							{
								if(href[0]!="#")
								{
									top.location=href
									top.document.mutex=top.document.mutex-enterPressMutexValue
								}
							}
							else if(cmd)
							{
								cmd=cmd.replace(/(\(|,)\s*this\s*(,|\))/g,"$1top.document.focusTable[top.document.focusTable.currentIndex]$2")
								if(top.frames && top.frames.length)
									cmd="top.frames[1]." + cmd;
								eval(cmd);							
								top.document.mutex=top.document.mutex-enterPressMutexValue
							}
							else if(current.onclick)
							{
								current.onclick()
								top.document.mutex=top.document.mutex-enterPressMutexValue
							}
						}

						if(current && current.nodeType == Node.ELEMENT_NODE && current.nodeName=="A")
						{
							var href=current.getAttribute("href")
							if(href && href[0]=="#")
							{
								if(top.document.focusTable)
									FindNextIndexedFocus("match",href.slice(1))
							}						 
						}
					}
				  	break;

				case 16: //shift
					if(top.document.modifiers & Event.SHIFT_MASK)
						top.document.modifiers = top.document.modifiers - Event.SHIFT_MASK;
					break;

				case 17: //ctrl
					if(top.document.modifiers & Event.CONTROL_MASK)
						top.document.modifiers = top.document.modifiers - Event.CONTROL_MASK;
					break;

				case 18: //alt
					if(top.document.modifiers & Event.ALT_MASK)
						top.document.modifiers = top.document.modifiers - Event.ALT_MASK;
					break;

				case 35: //end
					if(top.document.mutex & endPressMutexValue)
					{
						if(top.document.modifiers & Event.SHIFT_MASK)
						{
							if(top.document.screenReaderText==null)
								LoadFocalIndex("index|screen-read")

							if(top.document.screenReaderText)
								top.document.screenReaderIndex=top.document.screenReaderText.length;
							routeEvt=0;
						}
						top.document.mutex=top.document.mutex-endPressMutexValue
					}
					break;

				case 36: //home
					if(top.document.mutex & homePressMutexValue)
					{
						if(top.document.modifiers & Event.SHIFT_MASK)
						{
							if(top.document.screenReaderText==null)
								LoadFocalIndex("index|screen-read")

							if(top.document.screenReaderText)
								top.document.screenReaderIndex=0;
							routeEvt=0;
						}
						top.document.mutex=top.document.mutex-homePressMutexValue
					}
					break;

				case 38: //up arrow
					if(top.document.mutex & upArrowPressMutexValue)
					{
						if(top.document.modifiers & Event.SHIFT_MASK)
						{
							if(top.document.screenReaderText==null)
								LoadFocalIndex("index|screen-read")

							if(top.document.screenReaderText && top.document.screenReaderIndex > 0)
							{
								var index=top.document.screenReaderIndex-1

								while(index && top.document.screenReaderText[index] !="\n")
									index--

								SetScreenReaderText(top.document.screenReaderText.slice(index,top.document.screenReaderIndex))

								top.document.screenReaderIndex=index;
							}
							routeEvt=0;
						}
						top.document.mutex=top.document.mutex-upArrowPressMutexValue
					}
					break;

				case 40: //down arrow
					if(top.document.mutex & downArrowPressMutexValue)
					{
						if((top.document.modifiers & Event.CONTROL_MASK) || (top.document.modifiers & Event.SHIFT_MASK))
						{
							if(top.document.screenReaderText==null)
								LoadFocalIndex("index|screen-read")

							if(top.document.screenReaderText)
							{
								if((top.document.modifiers - (Event.CONTROL_MASK | Event.SHIFT_MASK))==0)
									SetScreenReaderText(top.document.screenReaderText)
								else if(top.document.screenReaderIndex < top.document.screenReaderText.length)
								{
									var index=top.document.screenReaderText.indexOf("\n",top.document.screenReaderIndex + 1)
									var text=""

									if(index == -1)
									{
										text=top.document.screenReaderText.slice(top.document.screenReaderIndex)									
										top.document.screenReaderIndex = top.document.screenReaderText.length
									}
									else
									{
										text=top.document.screenReaderText.slice(top.document.screenReaderIndex,index)
										top.document.screenReaderIndex=index
									}

									if(text)
										SetScreenReaderText(text)
								}								
							}
							routeEvt=0;
						}
						top.document.mutex=top.document.mutex-downArrowPressMutexValue
					}
					break;

				case 72:
				case 104:
					if((top.document.modifiers & Event.CONTROL_MASK) && (top.document.modifiers & Event.SHIFT_MASK))
						SetScreenReaderText("$help$");
					break;					 
			}		 
			break;

		case "click":
			if(top.frames.length)
			{
				if(top.document.focusTable &&
					(evt.target.ownerDocument!=top.document.focusTable[top.document.focusTable.currentIndex].ownerDocument))
				{
					SetWindowFilters(FindWindow(top,evt.target.ownerDocument),"filter")
					if(top.document.focusTable)
						FindNextIndexedFocus("winobj",top.document.currentWin)
				}
			}
			break;

		case "focus":
			if(evt.target.toString() == "[object HTMLDocument]")
				SetWindowFilters(FindWindow(top,evt.target),"filter")
			break;
	}

	if(routeEvt)
		routeEvent(evt);

	return true;
} 

function KBInvoke(evt,method,hotkey,modifier)
{
	if(hotkey!=null || (top.document.mutex & enterPressMutexValue))
	{
		var invoke=0
		if(KBInvoke.arguments.length == 2)
		{
			if(evt.which==13)
				invoke=1
		}
		else if(KBInvoke.arguments.length > 2)
		{
			var hotkeys;
			if(typeof(hotkey)=="number")
				hotkeys=[hotkey];
			else
				hotkeys=hotkey

			for(var i=0;i<hotkeys.length;i++)
			{
				if(evt.which==hotkeys[i])
				{
					if(modifier)
					{
						if(top.document.modifiers & modifier)
							invoke=1
					}
					else
						invoke=1	
				}

				if(invoke)
					break;
			}
		}

		if(invoke)
		{
			method=method.replace(/(\(|,)\s*this\s*(,|\))/g,"$1top.document.focusTable[top.document.focusTable.currentIndex]$2")
			if(top.frames && top.frames.length)
				method="top.frames[1]." + method;
			eval(method)
		}

		if(hotkey==13)
			top.document.mutex=top.document.mutex-enterPressMutexValue
	}
}

function FindWindow(win,target)
{
	var retval=null

	if(target.toString()=="[object Window]")
	{
		if(win==target)
		{
			if(win==top)
				return null
			else
				return "Set Parent Window"
		}
	}
	else
	{
		if(win.document==target)
			return win
	}

	if(retval==null && win.frames.length)
	{
		for(var i=0;i<win.frames.length;i++)
		{
			retval=FindWindow(win.frames[i],target)

			if(retval)
			{
				if(retval=="Set Parent Window")
					retval=win
				break
			}
		}
	}

	return retval
}

function SetWindowFilters(win,mode)
{
	if(win.toString()!="[object Window]")
		return

	if(mode=="init")
	{
		win.captureEvents(Event.CLICK | Event.FOCUS)
		win.onclick=EventFilter;
		win.onfocus=EventFilter;

		if(win.frames.length)
		{
			for(var i=0;i<win.frames.length;i++)
				SetWindowFilters(win.frames[i],mode)
		}
	}
	else if(mode=="filter")
	{
		if(win!=top.document.currentWin)
		{
			if(top.document.currentWin)
				SetWindowFilters(top.document.currentWin,"release")
			win.captureEvents(Event.KEYDOWN | Event.KEYUP );
			win.onkeydown=EventFilter;
			win.onkeyup=EventFilter;
			top.document.currentWin=win
		}
	}
	else if(mode=="release")
	{
		win.releaseEvents(Event.KEYDOWN | Event.KEYUP)
		top.document.currentWin=null
	}
	else if(mode=="releaseall")
	{
		win.releaseEvents(Event.KEYDOWN | Event.KEYUP)

		if(win.frames.length)
		{
			for(var i=0;i<win.frames.length;i++)
				SetWindowFilters(win.frames[i],mode)
		}

		top.document.currentWin=null
	}
}