/*********************************************************************************************
 Note:
 This file is for page specific functions.  If you are creating generic, common functions
 that span most of the pages it should be put in common.js
*********************************************************************************************/

var InstallBroker = Components.classes["@dugout/infield/instservice;1"].getService(Components.interfaces.IInstService);

function HackersMenu()
{
    GetExpandValue("$RunHackersMenu$");
}

var IFR_Timeout_ID=null;
function FlightRecorder(action)
{
	if(IFR_Timeout_ID)
	{
		clearTimeout(IFR_Timeout_ID);
		IFR_Timeout_ID=null;
	}

	var result = new Object();
	result.value=false;

	var frpath=GetExpandValue("$RegistryLookup,Software\\Hewlett-Packard\\upapp\\FRU,FRU-Dir$");

	if(frpath)
	{
		frpath=frpath + "hpqfruv.exe"
		InstallBroker.CheckFileExists(frpath,result);
	}
	
	switch(action)
	{
		case "install":
			if(result.value==false)
			{
				var HPIFile = new String();
				InstallBroker.GetProcessString("master.hpi", "2", HPIFile);
				HPIFile = HPIFile.value + "master.hpi";

				var installer=new String();
				InstallBroker.GetProcessString(HPIFile,"11",installer);
				installer=installer.value + "\\msiexec.exe";
				InstallBroker.CheckFileExists(installer,result);
				if(result.value!=false)
					installer = '"' + installer + '" /i "' + GetMacroValue("CDROOT") + '\\upapp\\upapp.msi" /q REBOOT="ReallySuppress"';

				if(result.value!=false)
					GetExpandValue('$CreateProcess,' + installer + '$');

				IFR_Timeout_ID = setTimeout('FlightRecorder("register")',5000);

				var exitAnchor=document.getElementById("exitApp");
				if(!exitAnchor)
					exitAnchor=document.getElementById("exitButton");

				if(exitAnchor)
				{
					exitAnchor=exitAnchor.getElementsByTagName("A");
					if(exitAnchor)
						exitAnchor[0].setAttribute("onclick","FlightRecorder('register');" + exitAnchor[0].getAttribute("onclick"))
				}
				break;
			}

		case "register":
			var ContextId='#Hewlett-Packard#Deskjet#' + GetMacroValue("PROD");
			if(result.value!=false && !GetExpandValue("$RegistryLookup,Software\\Hewlett-Packard\\upapp\\FRUClient,Stage_" + ContextId + "$"))
				GetExpandValue('$CreateProcess,"' + frpath + '" -I "' + ContextId + '"$');			
			break;
	}
}

function InvokeUninstall()
{
	var option=""
	if(top.document.URL.match(/\?(.+)$/))
		option=" -vforce_uninstall=" + RegExp.$1;

	GetExpandValue("$CreateProcess,^$UNINSTALLER^$" + option + "$");
	exitButton(true);
}

function InvokeWebReg()
{	
	var prnInfo=ProcessSysInfoItem("PrinterInfo");
	var serialId=null

	prnInfo=prnInfo.replace(/;/g,"");
	
	if(prnInfo.match(/sn#=\s*([^\s;,]+)/i))
		serialId="&serialId=" + RegExp.$1;

	LoadJumpURL('webreg','HP',serialId);
}

function InvokeISP()
{
	var result=new Object();
	result.value=false;

	var instRoot= GetMacroValue("CDROOT") + "\\isp\\HPSdpAPP\\setup\\install.exe";

	if(IsCDInserted(instRoot))
		GetExpandValue('$CreateProcess,' + '"' + instRoot + '" ' + GetMacroValue("HP_ISP_CMDLINE") + "$");
	else
		top.location.href="warn_insert_cd.html?eval=InvokeISP(),cdfile=" + instRoot;
}

function ExecMotive()
{
	var retval=false;
	var programPath=GetExpandValue('$MotiveInfo$');

	if(programPath)
	{
		var params='" "' + programPath.replace(/hpis.+$/i,"hpis\\") + '" -sf$'
		retval=GetExpandValue('$CreateProcess,"' + programPath + params)
	}

	return retval;
}

function GetDisplayValue(id)
{
	var displayVal=null;

	if(top.document.debug && id!="online_support")
		id="debug";

	switch(id)
	{
		case "online_support":
			if(GetExpandValue('$MotiveInfo$'))
				displayVal="MotiveServ"
			else
				displayVal="EmailServ"
			break;

		case "register":
			var strEregLangs = GetMacroValue("EREG_LANGS").toLowerCase();
			var strLang = GetMacroValue("LANG").toLowerCase();

			if(strEregLangs && strLang && (strEregLangs.indexOf(strLang) >=0))
				displayVal=true;
			else
				displayVal=false;
			break;

		case "printSample":
	  		var result = new Object();
			var sampleExt;
	  		result.value=false;

			if(GetMacroValue("SLEEK")=="true")
				sampleExt=".ldl";
			else
				sampleExt=".pcl";

	  		InstallBroker.CheckFileExists(GetMacroValue("INSTALLDIR") + "\\" + GetMacroValue("PROD") + "\\sample1" + sampleExt, result);
			if(result.value != false)
				displayVal=true;
			else
				displayVal=false;
			break;

		case "isp_offer":
			if(ProcessSysInfoItem("WindowsVersion").match(/^Microsoft\s+Windows\s+(NT|95|98$)/i))
				displayVal=false;
			else
			{
				var isp_offer=GetMacroValue("HP_ISP_AVAILABLE");

				if(isp_offer.toLowerCase()=="true")
					displayVal=true;
				else
					displayVal=false;
			}
			break;

		case "debug":
			displayVal=true;
			break;

		default:
			displayVal=false;
	}

	return displayVal;
}

function GetSysInfoItem(SysInfoItem)
{
	var retStr=ProcessSysInfoItem(SysInfoItem)

	if(retStr == "")
		retStr= "-------------"
	else
	{
		retStr=retStr.replace(/\n/g,"<P>");
		retStr=retStr.replace(/\,/g,"<BR>");
		retStr=retStr.replace(/\t/g," - ");
		retStr=retStr.replace(/\;/g,"");
	}

    return '<td width="60%" class="blockText">' + retStr + '</td>'
}

function DisplaySupportPhoneList(mode,ctrlNode)
{
	if(mode=="hide" && !top.document.debug)
	{
		var showList=true;
		var phonelist=GetElementFromPath("BODY,TABLE,TBODY");
		if(phonelist)
		{
			var elmntID=ProcessSysInfoItem("RegionInfo")

			if(elmntID)
			{
				var tablehead=GetElementFromPath("BODY,TABLE,THEAD");
				if(tablehead)
				{
					var elmnt=GetElementFromPath("BODY,TABLE,TBODY,TR:" + elmntID);
					var elmntctrl=GetElementFromPath("BODY,TABLE,THEAD,TR:phonelist_ctrl")

					if(elmnt && elmntctrl)
					{
						var extent;

						extent=elmnt.getAttribute("extent");
						if(extent)
							extent=parseInt(extent);
						else
							extent=1

						for(var i=1;elmnt && i<=extent;i++)
						{
							if(i != 1)
								elmnt=GetElementFromPath("BODY,TABLE,TBODY,TR:" + elmntID + i);								

							if(elmnt)
								tablehead.insertBefore(elmnt,elmntctrl)
						}							

						top.document.phonelist=phonelist
						phonelist.parentNode.removeChild(phonelist);
						showList=false;
					}						
				}
			}		
		}

		if(showList)
		{
			var elmntctrl=GetElementFromPath("BODY,TABLE,THEAD,TR:phonelist_ctrl")
			elmntctrl.parentNode.removeChild(elmntctrl);
		}		
	}
	else if(ctrlNode && top.document.phonelist)
	{
		var tableNode=ctrlNode;

		while(tableNode.parentNode)
		{
			tableNode=tableNode.parentNode;
			if(tableNode.nodeName=="TABLE")
				break;
		}

		ctrlNode.parentNode.removeChild(ctrlNode)
		if(tableNode && (tableNode.nodeName=="TABLE"))
			tableNode.appendChild(top.document.phonelist);

		LoadFocalIndex("reset");
	}
}

function HidePrintDemoButtons()
{
	var result = new Object();
	var sampleExt;
	if(GetMacroValue("SLEEK")=="true")
		sampleExt=".ldl";
	else
		sampleExt=".pcl";

	// look for files that exist and if they don't then show the corresponding button
	for( var i = 1; i <= 2; i++ )
	{
  		result.value = false;
	
	    // set dugout path to dugout directory + product subdirectory
  		InstallBroker.CheckFileExists(GetMacroValue("INSTALLDIR") + "\\" + GetMacroValue("PROD") + "\\sample" + i + sampleExt, result);
	  
	  	if((result.value == false) && !top.document.debug)
			DisplayElement("div:printSample"+i,"hidden")
	}

	var button=GetElementFromPath("div:printSample1,button");
	if(GetElementFromPath("div:printSample2"))
	{
		if(button && button.getAttribute("alt"))
		{
			button.removeChild(button.firstChild);
			button.appendChild(document.createTextNode(button.getAttribute("alt")))
		}
	}
	else if(button)
		button.setAttribute("alt",button.firstChild.data);
}

// ===========================================
// Added features for software install
// ===========================================
var ISW_Timeout_ID=null;
function InstallSoftware(hpi,softwareName)
{
	if(ISW_Timeout_ID)
	    clearTimeout(ISW_Timeout_ID);

	if(IsCDInserted())
	{
		if(top.document.URL.match(/warn_insert_cd.html/i))
		{
			var elementObj=GetElementFromPath("div:okButton,img");
			if(elementObj)
			{
				elementObj.parentNode.removeChild(elementObj);
				elementObj=GetElementFromPath("div:okButton,a")
				if(elementObj)
				{
					elementObj.setAttribute("id","link")
					elementObj=GetElementFromPath("div:okButton,a,img")
					elementObj.setAttribute("style","link")
					//elementObj.setAttribute("onclick","InstallSoftware()")
				}
			}
		}

		var args=GetQueryStringArgs();

		if(args && (!hpi || !softwareName))
		{
			hpi=args.hpi;
			softwareName=args.swname;
		}

		if(hpi && softwareName)
		{
		    InstallBroker.InitProcess( null, false );
		        
		    // set product and lang
		    InstallBroker.SetProcessString( "product", GetMacroValue("PROD"));
		    InstallBroker.SetProcessString( "lang", GetMacroValue("LANG"));

	        if (hpi == 'master.hpi') 
	        {  
		        //quickHelp for alternate localization language PDF
		        InstallBroker.SetProcessString('alt_lang_pdf',softwareName);
		        InstallBroker.Process(GetMacroValue("INFIELD_DIR") + "\\master.hpi",'view_alt_lang_pdf');
		    }
		    else
		    {
		         //3rd party software install
		        InstallBroker.Process(GetMacroValue("INFIELD_DIR")+ "\\" + hpi,softwareName);
		    }
		}
		else if(args.eval)
		{
			try{eval(args.eval)}catch(e){}
		}

		top.back();
    }
    else if(!top.document.URL.match(/warn_insert_cd.html/i))
    {
	    InstallBroker.InitProcess( null, false );
	    InstallBroker.SetProcessString( "product", GetMacroValue("PROD"));
	    InstallBroker.SetProcessString( "lang", GetMacroValue("LANG"));

        InstallBroker.DisableAutoRun();
        top.location.href = "warn_insert_cd.html?"+"hpi="+hpi+","+"swname="+softwareName;
    }
	else
		ISW_Timeout_ID = setTimeout('InstallSoftware()',1000);
}  


function IsCDInserted(fileToCheck)
{
    var result=new Object();
    result.value = false;

	if(fileToCheck)
	  	InstallBroker.CheckFileExists(fileToCheck, result);
	else
	{
		var args=GetQueryStringArgs();
		if(args.cdfile)
		  	InstallBroker.CheckFileExists(args.cdfile, result);
		else
		  	InstallBroker.CheckFileExists(GetMacroValue("CDROOT") + "\\hpsetup.ini", result);
	}
  	
  	return result.value;
}


function GetQueryStringArgs()
{
	var args = new Object();
	if(top.document.URL.match(/\?([^\?]+)$/))
	{
		var query=RegExp.$1; 		//get query string.
		var pairs = query.split(",");				//break at comma.

		for (var i=0; i< pairs.length; i++) 
		{
			keyval=unescape(pairs[i])
			if(keyval.match(/^([^=]+)=(.+)$/))
			{
				//LogMessage(0,"key:" + RegExp.$1 + " | value:" + RegExp.$2)
				args[RegExp.$1]=RegExp.$2
			}
		}
	}

	return args;		
}
