////////////////////////////////////////////////////////////////////////////////
// Set Product State Variables 
////////////////////////////////////////////////////////////////////////////////
//
// To create a new product out of pre-existing features, localized strings, os(s), io connects, etc.:
// 1. create a new case defined by how the product number is stored in hpi file (w/'c' w/o 'c') by copying and pasting existing one
// 2. set the *second* parameter of the HpfInst.SetProcessString to the appropriate value (see documentation)


function SetInitialStateVariables()
{	
	var HpfInst = Components.classes["@dugout/infield/instservice;1"].getService(Components.interfaces.IInstService);

	var strTempPath = new String();
	HpfInst.GetProcessString("master.hpi", "2", strTempPath);
	var HPIFile = strTempPath.value + "master.hpi";

	var Product = new String(); 
	HpfInst.GetProcessString(HPIFile, "product", Product);

	switch(Product.value.toLowerCase())
	{
		case "3420":
			UtilBroker.HPSetMacro("SLEEK", "true");					//true or false (a sleek printer is one for which rendering is not done in the printer itself)
			HpfInst.SetProcessString("network_support", "false");   		//true or false
			HpfInst.SetProcessString("io1", "usb");					//usb, bth or parallel
			HpfInst.SetProcessString("io2", "false");				//false, usb, bth or parallel
			HpfInst.SetProcessString("autocalibrate", "false");			//true of false (user does nothing)
			HpfInst.SetProcessString("unit_prep", "processOne");			//processOne (outside only), processTwo (left & outside) or processThree (right & outside)
			HpfInst.SetProcessString("calibration_support", "processOne");		//false, processOne (4 + 1 sections) or processTwo (4 sections) (user provides feedback)
			HpfInst.SetProcessString("duplexer", "false");				//true, false or optional
			HpfInst.SetProcessString("loadpaper_support", "processOne");		//processOne through processSeven
			HpfInst.SetProcessString("installcartridge_support", "tig2.xTwo");	//tig2.0, tig2.5, tig2.xOne, tig2.xTwo
			HpfInst.SetProcessString("single_cartridge", "false");			//false, tri-color or black
			HpfInst.SetProcessString("oem", "false");		                //true or false (is oem product)
			HpfInst.SetProcessString("pa", "true");					//true or false (has hp printer assistant) ~~ only for OEM work to override 
			HpfInst.SetProcessString("isp", "n/a");					//true or false (has hp isp offerings) ~~ only for OEM work to override 
			HpfInst.SetProcessString("ereg", "n/a");				//true or false (has hp ereg offering) ~~ only for OEM work to override 
			HpfInst.SetProcessString("printsample", "n/a");				//true or false (has print sample) ~~ only for OEM work to override 	
			break;
		case "3320":
			UtilBroker.HPSetMacro("SLEEK", "true");			
			HpfInst.SetProcessString("network_support", "false");   		
			HpfInst.SetProcessString("io1", "usb");					
			HpfInst.SetProcessString("io2", "false");					
			HpfInst.SetProcessString("autocalibrate", "false");
			HpfInst.SetProcessString("unit_prep", "processOne");			
			HpfInst.SetProcessString("calibration_support", "processOne");
			HpfInst.SetProcessString("duplexer", "false");
			HpfInst.SetProcessString("loadpaper_support", "processOne");
			HpfInst.SetProcessString("installcartridge_support", "tig2.xTwo");
			HpfInst.SetProcessString("single_cartridge", "tri-color");	
			HpfInst.SetProcessString("oem", "false");		                //true or false (is oem product)
			HpfInst.SetProcessString("pa", "true");					//true or false (has hp printer assistant) ~~ only for OEM work to override 
			HpfInst.SetProcessString("isp", "n/a");					//true or false (has hp isp offerings) ~~ only for OEM work to override 
			HpfInst.SetProcessString("ereg", "n/a");				//true or false (has hp ereg offering) ~~ only for OEM work to override 
			HpfInst.SetProcessString("printsample", "n/a");				//true or false (has print sample) ~~ only for OEM work to override 	
			break;
		case "3820":
			UtilBroker.HPSetMacro("SLEEK", "false");			
			HpfInst.SetProcessString("network_support", "false");   		
			HpfInst.SetProcessString("io1", "usb");					
			HpfInst.SetProcessString("io2", "parallel");					
			HpfInst.SetProcessString("autocalibrate", "false");
			HpfInst.SetProcessString("unit_prep", "processOne");			
			HpfInst.SetProcessString("calibration_support", "processTwo");
			HpfInst.SetProcessString("duplexer", "false");
			HpfInst.SetProcessString("loadpaper_support", "processFour");
			HpfInst.SetProcessString("installcartridge_support", "tig2.5");
			HpfInst.SetProcessString("single_cartridge", "false");		
			HpfInst.SetProcessString("oem", "false");		                //true or false (is oem product)
			HpfInst.SetProcessString("pa", "true");					//true or false (has hp printer assistant) ~~ only for OEM work to override 
			HpfInst.SetProcessString("isp", "n/a");					//true or false (has hp isp offerings) ~~ only for OEM work to override 
			HpfInst.SetProcessString("ereg", "n/a");				//true or false (has hp ereg offering) ~~ only for OEM work to override 
			HpfInst.SetProcessString("printsample", "n/a");				//true or false (has print sample) ~~ only for OEM work to override 	
			break;
		case "3816":
			UtilBroker.HPSetMacro("SLEEK", "false");
			HpfInst.SetProcessString("network_support", "false");   		
			HpfInst.SetProcessString("io1", "usb");					
			HpfInst.SetProcessString("io2", "parallel");					
			HpfInst.SetProcessString("autocalibrate", "false");
			HpfInst.SetProcessString("unit_prep", "processOne");			
			HpfInst.SetProcessString("calibration_support", "processTwo");
			HpfInst.SetProcessString("duplexer", "false");
			HpfInst.SetProcessString("loadpaper_support", "processFour");
			HpfInst.SetProcessString("installcartridge_support", "tig2.5");
			HpfInst.SetProcessString("single_cartridge", "false");		
			HpfInst.SetProcessString("oem", "false");		                //true or false (is oem product)
			HpfInst.SetProcessString("pa", "true");					//true or false (has hp printer assistant) ~~ only for OEM work to override 
			HpfInst.SetProcessString("isp", "n/a");					//true or false (has hp isp offerings) ~~ only for OEM work to override 
			HpfInst.SetProcessString("ereg", "n/a");				//true or false (has hp ereg offering) ~~ only for OEM work to override 
			HpfInst.SetProcessString("printsample", "n/a");				//true or false (has print sample) ~~ only for OEM work to override 	
			break;
		case "3810":
			UtilBroker.HPSetMacro("SLEEK", "false");			
			HpfInst.SetProcessString("network_support", "false");   		
			HpfInst.SetProcessString("io1", "usb");					
			HpfInst.SetProcessString("io2", "parallel");					
			HpfInst.SetProcessString("autocalibrate", "false");
			HpfInst.SetProcessString("unit_prep", "processOne");			
			HpfInst.SetProcessString("calibration_support", "processTwo");
			HpfInst.SetProcessString("duplexer", "false");
			HpfInst.SetProcessString("loadpaper_support", "processFour");
			HpfInst.SetProcessString("installcartridge_support", "tig2.5");
			HpfInst.SetProcessString("single_cartridge", "false");		
			HpfInst.SetProcessString("oem", "false");		                //true or false (is oem product)
			HpfInst.SetProcessString("pa", "true");					//true or false (has hp printer assistant) ~~ only for OEM work to override 
			HpfInst.SetProcessString("isp", "n/a");					//true or false (has hp isp offerings) ~~ only for OEM work to override 
			HpfInst.SetProcessString("ereg", "n/a");				//true or false (has hp ereg offering) ~~ only for OEM work to override 
			HpfInst.SetProcessString("printsample", "n/a");				//true or false (has print sample) ~~ only for OEM work to override 	
			break;
		case "3819":
			UtilBroker.HPSetMacro("SLEEK", "false");
			HpfInst.SetProcessString("network_support", "false");   		
			HpfInst.SetProcessString("io1", "usb");					
			HpfInst.SetProcessString("io2", "parallel");					
			HpfInst.SetProcessString("autocalibrate", "false");
			HpfInst.SetProcessString("unit_prep", "processOne");			
			HpfInst.SetProcessString("calibration_support", "processTwo");
			HpfInst.SetProcessString("duplexer", "false");
			HpfInst.SetProcessString("loadpaper_support", "processFour");
			HpfInst.SetProcessString("installcartridge_support", "tig2.5");
			HpfInst.SetProcessString("single_cartridge", "false");		
			HpfInst.SetProcessString("oem", "false");		                //true or false (is oem product)
			HpfInst.SetProcessString("pa", "true");					//true or false (has hp printer assistant) ~~ only for OEM work to override 
			HpfInst.SetProcessString("isp", "n/a");					//true or false (has hp isp offerings) ~~ only for OEM work to override 
			HpfInst.SetProcessString("ereg", "n/a");				//true or false (has hp ereg offering) ~~ only for OEM work to override 
			HpfInst.SetProcessString("printsample", "n/a");				//true or false (has print sample) ~~ only for OEM work to override 	
			break;
		case "5550":
			UtilBroker.HPSetMacro("SLEEK", "false");		
			HpfInst.SetProcessString("network_support", "true");   		
			HpfInst.SetProcessString("io1", "usb");					
			HpfInst.SetProcessString("io2", "parallel");					
			HpfInst.SetProcessString("autocalibrate", "true");
			HpfInst.SetProcessString("unit_prep", "processOne");			
			HpfInst.SetProcessString("calibration_support", "false");
			HpfInst.SetProcessString("duplexer", "optional");
			HpfInst.SetProcessString("loadpaper_support", "processTwo");
			HpfInst.SetProcessString("installcartridge_support", "tig2.xOne");
			HpfInst.SetProcessString("single_cartridge", "false");		
			HpfInst.SetProcessString("oem", "false");		                //true or false (is oem product)
			HpfInst.SetProcessString("pa", "true");					//true or false (has hp printer assistant) ~~ only for OEM work to override 
			HpfInst.SetProcessString("isp", "n/a");					//true or false (has hp isp offerings) ~~ only for OEM work to override 
			HpfInst.SetProcessString("ereg", "n/a");				//true or false (has hp ereg offering) ~~ only for OEM work to override 
			HpfInst.SetProcessString("printsample", "n/a");				//true or false (has print sample) ~~ only for OEM work to override 	
			break;
		case "5551":
			UtilBroker.HPSetMacro("SLEEK", "false");		
			HpfInst.SetProcessString("network_support", "true");   		
			HpfInst.SetProcessString("io1", "usb");					
			HpfInst.SetProcessString("io2", "parallel");					
			HpfInst.SetProcessString("autocalibrate", "true");
			HpfInst.SetProcessString("unit_prep", "processOne");			
			HpfInst.SetProcessString("calibration_support", "false");
			HpfInst.SetProcessString("duplexer", "true");
			HpfInst.SetProcessString("loadpaper_support", "processThree");
			HpfInst.SetProcessString("installcartridge_support", "tig2.xOne");
			HpfInst.SetProcessString("single_cartridge", "false");		
			HpfInst.SetProcessString("oem", "false");		                //true or false (is oem product)
			HpfInst.SetProcessString("pa", "true");					//true or false (has hp printer assistant) ~~ only for OEM work to override 
			HpfInst.SetProcessString("isp", "n/a");					//true or false (has hp isp offerings) ~~ only for OEM work to override 
			HpfInst.SetProcessString("ereg", "n/a");				//true or false (has hp ereg offering) ~~ only for OEM work to override 
			HpfInst.SetProcessString("printsample", "n/a");				//true or false (has print sample) ~~ only for OEM work to override 	
			break;
		case "995c":
			UtilBroker.HPSetMacro("SLEEK", "false");		
			HpfInst.SetProcessString("network_support", "false");   		
			HpfInst.SetProcessString("io1", "bth");					
			HpfInst.SetProcessString("io2", "usb");					
			HpfInst.SetProcessString("autocalibrate", "true");
			HpfInst.SetProcessString("unit_prep", "processOne");			
			HpfInst.SetProcessString("calibration_support", "false");
			HpfInst.SetProcessString("duplexer", "true");
			HpfInst.SetProcessString("loadpaper_support", "processSeven");
			HpfInst.SetProcessString("installcartridge_support", "tig2.5");
			HpfInst.SetProcessString("single_cartridge", "false");	
			HpfInst.SetProcessString("oem", "false");		                //true or false (is oem product)
			HpfInst.SetProcessString("pa", "true");					//true or false (has hp printer assistant) ~~ only for OEM work to override 
			HpfInst.SetProcessString("isp", "n/a");					//true or false (has hp isp offerings) ~~ only for OEM work to override 
			HpfInst.SetProcessString("ereg", "n/a");				//true or false (has hp ereg offering) ~~ only for OEM work to override 
			HpfInst.SetProcessString("printsample", "n/a");				//true or false (has print sample) ~~ only for OEM work to override 	
			break;
		case "656c":
			UtilBroker.HPSetMacro("SLEEK", "false");		
			HpfInst.SetProcessString("network_support", "false");   		
			HpfInst.SetProcessString("io1", "usb");					
			HpfInst.SetProcessString("io2", "false");					
			HpfInst.SetProcessString("autocalibrate", "false");
			HpfInst.SetProcessString("unit_prep", "processOne");			
			HpfInst.SetProcessString("calibration_support", "false");
			HpfInst.SetProcessString("duplexer", "false");
			HpfInst.SetProcessString("loadpaper_support", "processSix");
			HpfInst.SetProcessString("installcartridge_support", "tig2.0");
			HpfInst.SetProcessString("single_cartridge", "false");
			HpfInst.SetProcessString("oem", "false");		                //true or false (is oem product)
			HpfInst.SetProcessString("pa", "true");					//true or false (has hp printer assistant) ~~ only for OEM work to override 
			HpfInst.SetProcessString("isp", "n/a");					//true or false (has hp isp offerings) ~~ only for OEM work to override 
			HpfInst.SetProcessString("ereg", "n/a");				//true or false (has hp ereg offering) ~~ only for OEM work to override 
			HpfInst.SetProcessString("printsample", "n/a");				//true or false (has print sample) ~~ only for OEM work to override 	
			break;
		case "825c":
			UtilBroker.HPSetMacro("SLEEK", "false");		
			HpfInst.SetProcessString("network_support", "false");   		
			HpfInst.SetProcessString("io1", "usb");					
			HpfInst.SetProcessString("io2", "false");					
			HpfInst.SetProcessString("autocalibrate", "false");
			HpfInst.SetProcessString("unit_prep", "processOne");			
			HpfInst.SetProcessString("calibration_support", "false");
			HpfInst.SetProcessString("duplexer", "false");
			HpfInst.SetProcessString("loadpaper_support", "processSeven");
			HpfInst.SetProcessString("installcartridge_support", "tig2.5");
			HpfInst.SetProcessString("single_cartridge", "true");
			HpfInst.SetProcessString("oem", "false");		                //true or false (is oem product)
			HpfInst.SetProcessString("pa", "true");					//true or false (has hp printer assistant) ~~ only for OEM work to override 
			HpfInst.SetProcessString("isp", "n/a");					//true or false (has hp isp offerings) ~~ only for OEM work to override 
			HpfInst.SetProcessString("ereg", "n/a");				//true or false (has hp ereg offering) ~~ only for OEM work to override 
			HpfInst.SetProcessString("printsample", "n/a");				//true or false (has print sample) ~~ only for OEM work to override 	
			break;
		case "845c":
			UtilBroker.HPSetMacro("SLEEK", "false");		
			HpfInst.SetProcessString("network_support", "false");   		
			HpfInst.SetProcessString("io1", "usb");					
			HpfInst.SetProcessString("io2", "false");					
			HpfInst.SetProcessString("autocalibrate", "false");
			HpfInst.SetProcessString("unit_prep", "processOne");			
			HpfInst.SetProcessString("calibration_support", "false");
			HpfInst.SetProcessString("duplexer", "false");
			HpfInst.SetProcessString("loadpaper_support", "processSeven");
			HpfInst.SetProcessString("installcartridge_support", "tig2.5");
			HpfInst.SetProcessString("single_cartridge", "false");	
			HpfInst.SetProcessString("oem", "false");		                //true or false (is oem product)
			HpfInst.SetProcessString("pa", "true");					//true or false (has hp printer assistant) ~~ only for OEM work to override 
			HpfInst.SetProcessString("isp", "n/a");					//true or false (has hp isp offerings) ~~ only for OEM work to override 
			HpfInst.SetProcessString("ereg", "n/a");				//true or false (has hp ereg offering) ~~ only for OEM work to override 
			HpfInst.SetProcessString("printsample", "n/a");				//true or false (has print sample) ~~ only for OEM work to override 	
			break;
		case "916c":
			UtilBroker.HPSetMacro("SLEEK", "false");		
			HpfInst.SetProcessString("network_support", "false");   		
			HpfInst.SetProcessString("io1", "usb");					
			HpfInst.SetProcessString("io2", "parallel");					
			HpfInst.SetProcessString("autocalibrate", "false");
			HpfInst.SetProcessString("unit_prep", "processOne");			
			HpfInst.SetProcessString("calibration_support", "false");
			HpfInst.SetProcessString("duplexer", "false");
			HpfInst.SetProcessString("loadpaper_support", "processFive");
			HpfInst.SetProcessString("installcartridge_support", "tig2.5");
			HpfInst.SetProcessString("single_cartridge", "false");	
			HpfInst.SetProcessString("oem", "false");		                //true or false (is oem product)
			HpfInst.SetProcessString("pa", "true");					//true or false (has hp printer assistant) ~~ only for OEM work to override 
			HpfInst.SetProcessString("isp", "n/a");					//true or false (has hp isp offerings) ~~ only for OEM work to override 
			HpfInst.SetProcessString("ereg", "n/a");				//true or false (has hp ereg offering) ~~ only for OEM work to override 
			HpfInst.SetProcessString("printsample", "n/a");				//true or false (has print sample) ~~ only for OEM work to override 	
			break;
		case "940c":
			UtilBroker.HPSetMacro("SLEEK", "false");		
			HpfInst.SetProcessString("network_support", "false");   		
			HpfInst.SetProcessString("io1", "usb");					
			HpfInst.SetProcessString("io2", "parallel");					
			HpfInst.SetProcessString("autocalibrate", "false");
			HpfInst.SetProcessString("unit_prep", "processOne");			
			HpfInst.SetProcessString("calibration_support", "false");
			HpfInst.SetProcessString("duplexer", "false");
			HpfInst.SetProcessString("loadpaper_support", "processSeven");
			HpfInst.SetProcessString("installcartridge_support", "tig2.5");
			HpfInst.SetProcessString("single_cartridge", "false");	
			HpfInst.SetProcessString("oem", "false");		                //true or false (is oem product)
			HpfInst.SetProcessString("pa", "true");					//true or false (has hp printer assistant) ~~ only for OEM work to override 
			HpfInst.SetProcessString("isp", "n/a");					//true or false (has hp isp offerings) ~~ only for OEM work to override 
			HpfInst.SetProcessString("ereg", "n/a");				//true or false (has hp ereg offering) ~~ only for OEM work to override 
			HpfInst.SetProcessString("printsample", "n/a");				//true or false (has print sample) ~~ only for OEM work to override 	
			break;
		case "920c":
			UtilBroker.HPSetMacro("SLEEK", "false");		
			HpfInst.SetProcessString("network_support", "false");   		
			HpfInst.SetProcessString("io1", "usb");					
			HpfInst.SetProcessString("io2", "parallel");					
			HpfInst.SetProcessString("autocalibrate", "false");
			HpfInst.SetProcessString("unit_prep", "processOne");			
			HpfInst.SetProcessString("calibration_support", "false");
			HpfInst.SetProcessString("duplexer", "false");
			HpfInst.SetProcessString("loadpaper_support", "processFive");
			HpfInst.SetProcessString("installcartridge_support", "tig2.5");
			HpfInst.SetProcessString("single_cartridge", "false");
			HpfInst.SetProcessString("oem", "false");		                //true or false (is oem product)
			HpfInst.SetProcessString("pa", "true");					//true or false (has hp printer assistant) ~~ only for OEM work to override 
			HpfInst.SetProcessString("isp", "n/a");					//true or false (has hp isp offerings) ~~ only for OEM work to override 
			HpfInst.SetProcessString("ereg", "n/a");				//true or false (has hp ereg offering) ~~ only for OEM work to override 
			HpfInst.SetProcessString("printsample", "n/a");				//true or false (has print sample) ~~ only for OEM work to override 	
			break;

			////////////////////////////////////////////////////////////////////////////////
			// Added on 05/14/2002
			// Support for 930c has been added only for preload installation (for displaying the VPM preload congrats screen).
			// The exact product specifications for the 930c are not known as yet.
		case "930c":						
			HpfInst.SetProcessString("autocalibrate", "false");			
			HpfInst.SetProcessString("calibration_support", "false");			
			HpfInst.SetProcessString("oem", "false");		                //true or false (is oem product)
			HpfInst.SetProcessString("pa", "false");					//true or false (has hp printer assistant) ~~ only for OEM work to override 
			HpfInst.SetProcessString("isp", "n/a");					//true or false (has hp isp offerings) ~~ only for OEM work to override 
			HpfInst.SetProcessString("ereg", "n/a");				//true or false (has hp ereg offering) ~~ only for OEM work to override 
			HpfInst.SetProcessString("printsample", "n/a");				//true or false (has print sample) ~~ only for OEM work to override 	
			break;
			////////////////////////////////////////////////////////////////////////////////

		case "948c":
			UtilBroker.HPSetMacro("SLEEK", "false");		
			HpfInst.SetProcessString("network_support", "false");   		
			HpfInst.SetProcessString("io1", "usb");					
			HpfInst.SetProcessString("io2", "parallel");					
			HpfInst.SetProcessString("autocalibrate", "false");
			HpfInst.SetProcessString("unit_prep", "processOne");			
			HpfInst.SetProcessString("calibration_support", "false");
			HpfInst.SetProcessString("duplexer", "false");
			HpfInst.SetProcessString("loadpaper_support", "processFive");
			HpfInst.SetProcessString("installcartridge_support", "tig2.5");
			HpfInst.SetProcessString("single_cartridge", "false");	
			HpfInst.SetProcessString("oem", "false");		                //true or false (is oem product)
			HpfInst.SetProcessString("pa", "true");					//true or false (has hp printer assistant) ~~ only for OEM work to override 
			HpfInst.SetProcessString("isp", "n/a");					//true or false (has hp isp offerings) ~~ only for OEM work to override 
			HpfInst.SetProcessString("ereg", "n/a");				//true or false (has hp ereg offering) ~~ only for OEM work to override 
			HpfInst.SetProcessString("printsample", "n/a");				//true or false (has print sample) ~~ only for OEM work to override 	
			break;
		case "960c":
			UtilBroker.HPSetMacro("SLEEK", "false");		
			HpfInst.SetProcessString("network_support", "false");   		
			HpfInst.SetProcessString("io1", "usb");					
			HpfInst.SetProcessString("io2", "parallel");					
			HpfInst.SetProcessString("autocalibrate", "true");
			HpfInst.SetProcessString("unit_prep", "processOne");			
			HpfInst.SetProcessString("calibration_support", "false");
			HpfInst.SetProcessString("duplexer", "false");
			HpfInst.SetProcessString("loadpaper_support", "processSeven");
			HpfInst.SetProcessString("installcartridge_support", "tig2.5");
			HpfInst.SetProcessString("single_cartridge", "false");			
			HpfInst.SetProcessString("oem", "false");		                //true or false (is oem product)
			HpfInst.SetProcessString("pa", "true");					//true or false (has hp printer assistant) ~~ only for OEM work to override 
			HpfInst.SetProcessString("isp", "n/a");					//true or false (has hp isp offerings) ~~ only for OEM work to override 
			HpfInst.SetProcessString("ereg", "n/a");				//true or false (has hp ereg offering) ~~ only for OEM work to override 
			HpfInst.SetProcessString("printsample", "n/a");				//true or false (has print sample) ~~ only for OEM work to override 	
			break;
		case "980c":
			UtilBroker.HPSetMacro("SLEEK", "false");		
			HpfInst.SetProcessString("network_support", "false");   		
			HpfInst.SetProcessString("io1", "usb");					
			HpfInst.SetProcessString("io2", "parallel");					
			HpfInst.SetProcessString("autocalibrate", "true");
			HpfInst.SetProcessString("unit_prep", "processOne");			
			HpfInst.SetProcessString("calibration_support", "false");
			HpfInst.SetProcessString("duplexer", "false");
			HpfInst.SetProcessString("loadpaper_support", "processSeven");
			HpfInst.SetProcessString("installcartridge_support", "tig2.5");
			HpfInst.SetProcessString("single_cartridge", "false");	
			HpfInst.SetProcessString("oem", "false");		                //true or false (is oem product)
			HpfInst.SetProcessString("pa", "true");					//true or false (has hp printer assistant) ~~ only for OEM work to override 
			HpfInst.SetProcessString("isp", "n/a");					//true or false (has hp isp offerings) ~~ only for OEM work to override 
			HpfInst.SetProcessString("ereg", "n/a");				//true or false (has hp ereg offering) ~~ only for OEM work to override 
			HpfInst.SetProcessString("printsample", "n/a");				//true or false (has print sample) ~~ only for OEM work to override 	
			break;
		case "990c":
			UtilBroker.HPSetMacro("SLEEK", "false");		
			HpfInst.SetProcessString("network_support", "false");   		
			HpfInst.SetProcessString("io1", "usb");					
			HpfInst.SetProcessString("io2", "parallel");					
			HpfInst.SetProcessString("autocalibrate", "true");
			HpfInst.SetProcessString("unit_prep", "processOne");			
			HpfInst.SetProcessString("calibration_support", "false");
			HpfInst.SetProcessString("duplexer", "false");
			HpfInst.SetProcessString("loadpaper_support", "processSeven");
			HpfInst.SetProcessString("installcartridge_support", "tig2.5");
			HpfInst.SetProcessString("single_cartridge", "false");		
			HpfInst.SetProcessString("oem", "false");		                //true or false (is oem product)
			HpfInst.SetProcessString("pa", "true");					//true or false (has hp printer assistant) ~~ only for OEM work to override 
			HpfInst.SetProcessString("isp", "n/a");					//true or false (has hp isp offerings) ~~ only for OEM work to override 
			HpfInst.SetProcessString("ereg", "n/a");				//true or false (has hp ereg offering) ~~ only for OEM work to override 
			HpfInst.SetProcessString("printsample", "n/a");				//true or false (has print sample) ~~ only for OEM work to override 	
			break;
		case "picty990":
			UtilBroker.HPSetMacro("SLEEK", "false");		
			HpfInst.SetProcessString("network_support", "true");   		
			HpfInst.SetProcessString("io1", "usb");					
			HpfInst.SetProcessString("io2", "parallel");					
			HpfInst.SetProcessString("autocalibrate", "true");
			HpfInst.SetProcessString("unit_prep", "processOne");			
			HpfInst.SetProcessString("calibration_support", "false");
			HpfInst.SetProcessString("duplexer", "false");
			HpfInst.SetProcessString("loadpaper_support", "processTwo");
			HpfInst.SetProcessString("installcartridge_support", "tig2.xOne");
			HpfInst.SetProcessString("single_cartridge", "false");		
			HpfInst.SetProcessString("oem", "true");		                //true or false (is oem product)
			HpfInst.SetProcessString("pa", "true");					//true or false (has hp printer assistant) ~~ only for OEM work to override 
			HpfInst.SetProcessString("isp", "n/a");					//true or false (has hp isp offerings) ~~ only for OEM work to override 
			HpfInst.SetProcessString("ereg", "n/a");				//true or false (has hp ereg offering) ~~ only for OEM work to override 
			HpfInst.SetProcessString("printsample", "n/a");				//true or false (has print sample) ~~ only for OEM work to override 	
			break;
		case "picty870":
			UtilBroker.HPSetMacro("SLEEK", "false");		
			HpfInst.SetProcessString("network_support", "false");   		
			HpfInst.SetProcessString("io1", "usb");					
			HpfInst.SetProcessString("io2", "parallel");					
			HpfInst.SetProcessString("autocalibrate", "false");
			HpfInst.SetProcessString("unit_prep", "processOne");			
			HpfInst.SetProcessString("calibration_support", "false");
			HpfInst.SetProcessString("duplexer", "false");
			HpfInst.SetProcessString("loadpaper_support", "processFive");
			HpfInst.SetProcessString("installcartridge_support", "tig2.5");
			HpfInst.SetProcessString("single_cartridge", "false");	
			HpfInst.SetProcessString("oem", "true");		                //true or false (is oem product)
			HpfInst.SetProcessString("pa", "true");					//true or false (has hp printer assistant) ~~ only for OEM work to override 
			HpfInst.SetProcessString("isp", "n/a");					//true or false (has hp isp offerings) ~~ only for OEM work to override 
			HpfInst.SetProcessString("ereg", "n/a");				//true or false (has hp ereg offering) ~~ only for OEM work to override 
			HpfInst.SetProcessString("printsample", "n/a");				//true or false (has print sample) ~~ only for OEM work to override 	
			break;
		case "picty770":
			UtilBroker.HPSetMacro("SLEEK", "false");		
			HpfInst.SetProcessString("network_support", "false");   		
			HpfInst.SetProcessString("io1", "usb");					
			HpfInst.SetProcessString("io2", "false");					
			HpfInst.SetProcessString("autocalibrate", "false");
			HpfInst.SetProcessString("unit_prep", "processOne");			
			HpfInst.SetProcessString("calibration_support", "false");
			HpfInst.SetProcessString("duplexer", "false");
			HpfInst.SetProcessString("loadpaper_support", "processSeven");
			HpfInst.SetProcessString("installcartridge_support", "tig2.5");
			HpfInst.SetProcessString("single_cartridge", "false");	
			HpfInst.SetProcessString("oem", "true");		                //true or false (is oem product)
			HpfInst.SetProcessString("pa", "true");					//true or false (has hp printer assistant) ~~ only for OEM work to override 
			HpfInst.SetProcessString("isp", "n/a");					//true or false (has hp isp offerings) ~~ only for OEM work to override 
			HpfInst.SetProcessString("ereg", "n/a");				//true or false (has hp ereg offering) ~~ only for OEM work to override 
			HpfInst.SetProcessString("printsample", "n/a");				//true or false (has print sample) ~~ only for OEM work to override 	
			break;
	}

	//do not edit any part of the following (start)
	//initial states for all products
	HpfInst.SetProcessString("second_troubleshoot_attempt", "false");
	HpfInst.SetProcessString("assist_install", "false");
	HpfInst.SetProcessString("unassist_install_done", "false");
	HpfInst.SetProcessString("io_connect", "unknown");
	HpfInst.SetProcessString("in_troubleshoot", "false");	
	HpfInst.SetProcessString("bth_install_to_file", "false");	
	HpfInst.SetProcessString("network_install", "unknown");
	HpfInst.SetProcessString("usb_port_detection", "unknown");
	//do not edit any part of the following (finish)

	HpfInst.SetProcessString("current_step_number", "1");

	//get info to determine conditional states
	var OS = new String();  
	HpfInst.GetProcessString(HPIFile, "os", OS);

	var IO1 = new String(); 
	HpfInst.GetProcessString(HPIFile, "io1", IO1);

	var IO2 = new String(); 
	HpfInst.GetProcessString(HPIFile, "io2", IO2);

	var PA = new String(); 
	HpfInst.GetProcessString(HPIFile, "pa", PA);

	var CartridgeType = new String(); 
	HpfInst.GetProcessString(HPIFile, "installcartridge_support", CartridgeType);
	
	//*only* edit any part of the following *if* conditions change that define states (start)
	//determine conditional states
	if ((IO1.value == "usb") && (IO2.value == "false"))
	{
		HpfInst.SetProcessString("usb_only", "true");
		HpfInst.SetProcessString("io_connect", "usb");
	}
	else
	{
		HpfInst.SetProcessString("usb_only", "false");
	}

	if ((CartridgeType.value == "tig2.xOne") || (CartridgeType.value == "tig2.xTwo"))
	{
		HpfInst.SetProcessString("invert_cartridge", "false");
	}
	else
	{
		HpfInst.SetProcessString("invert_cartridge", "true");
	}

	if(PA.value.toLowerCase() == "false")
	{
		HpfInst.SetProcessString("segue", "false");
	}
	else
	{
		HpfInst.SetProcessString("segue", "true");
	}

	if ((OS.value.toLowerCase() == "winnt4") || (OS.value.toLowerCase() == "win95"))
	{
		HpfInst.SetProcessString("os_no_support_usb", "true");
	}
	else
	{
		HpfInst.SetProcessString("os_no_support_usb", "false");
	}

	if ((OS.value.toLowerCase() == "winnt4") || (OS.value.toLowerCase() == "win95") || (OS.value.toLowerCase() == "winme") || (OS.value.toLowerCase() == "win98"))
	{
		HpfInst.SetProcessString("os_no_support_bth", "true");
	}
	else
	{
		HpfInst.SetProcessString("os_no_support_bth", "false");
	}

	if ((IO1.value == "bth") || (IO2.value == "bth"))
	{
		HpfInst.SetProcessString("has_bth", "true");
	}
	else
	{
		HpfInst.SetProcessString("has_bth", "false");
	}
	
	if ((Product.value.toLowerCase() == "3420") || (Product.value.toLowerCase() == "3320"))
	{
	   if ((OS.value.toLowerCase() == "win98") || (OS.value.toLowerCase() == "win98se") || (OS.value.toLowerCase() == "winme"))
	   {
		   HpfInst.SetProcessString("conduct_usb_check", "true");
	   }
	   else
	   {
		   HpfInst.SetProcessString("conduct_usb_check", "false");
	   }	
	}
	else
	{
		HpfInst.SetProcessString("conduct_usb_check", "false");
	}
	//*only* edit any part of the following *if* conditions change that define states (finish)	
}
