/*********************************************************************************************
 Note:
 This file is for page specific functions.  If you are creating generic, common functions
 that span most of the pages it should be put in vpm_common.js
*********************************************************************************************/

var InstallBroker = Components.classes["@dugout/infield/instservice;1"].getService(Components.interfaces.IInstService);

var IFR_Timeout_ID=null;
function FlightRecorder(action)
{
	if(IFR_Timeout_ID)
	{
		clearTimeout(IFR_Timeout_ID);
		IFR_Timeout_ID=null;
	}

	var result = new Object();
	result.value=false;

	var frpath=GetExpandValue("$RegistryLookup,Software\\Hewlett-Packard\\upapp\\FRU,FRU-Dir$");

	if(frpath)
	{
		frpath=frpath + "hpqfruv.exe"
		InstallBroker.CheckFileExists(frpath,result);
	}
	
	switch(action)
	{
		case "install":
			if(result.value==false)
			{
				var installer=new String();
				InstallBroker.GetProcessString(HPIFile,"11",installer);
				installer=installer.value + "\\msiexec.exe";
				InstallBroker.CheckFileExists(installer,result);
				if(result.value!=false)
					installer = '"' + installer + '" /i "' + GetMacroValue("CDROOT") + '\\upapp\\upapp.msi" /q REBOOT="ReallySuppress"';

				if(result.value!=false)
					GetExpandValue('$CreateProcess,' + installer + '$');

				IFR_Timeout_ID = setTimeout('FlightRecorder("register")',5000);

				var exitAnchor=document.getElementById("exitApp");
				if(exitAnchor)
				{
					exitAnchor=exitAnchor.getElementsByTagName("A");
					if(exitAnchor)
						exitAnchor[0].setAttribute("onclick","FlightRecorder('register');" + exitAnchor[0].getAttribute("onclick"))
				}
				break;
			}

		case "register":
			var ContextId='#Hewlett-Packard#Deskjet#' + GetMacroValue("PROD");
			if(result.value!=false && !GetExpandValue("$RegistryLookup,Software\\Hewlett-Packard\\upapp\\FRUClient,Stage_" + ContextId + "$"))
				GetExpandValue('$CreateProcess,"' + frpath + '" -I "' + ContextId + '"$');			
			break;
	}
}

function InvokeWebReg()
{	
	var prnInfo=ProcessSysInfoItem("PrinterInfo");
	var serialId=null

	prnInfo=prnInfo.replace(/;/g,"");
	
	if(prnInfo.match(/sn#=\s*([^\s;,]+)/i))
		serialId="&serialId=" + RegExp.$1;

	LoadJumpURL('webreg','HP',serialId);
}

function InvokeISP()
{
	var result=new Object();
	result.value=false;

	var instRoot= GetMacroValue("CDROOT") + "\\isp\\HPSdpAPP\\setup\\install.exe";

	if(IsCDInserted(instRoot))
		GetExpandValue('$CreateProcess,' + '"' + instRoot + '" ' + GetMacroValue("HP_ISP_CMDLINE") + "$");
	else
		top.location.href="warn_insert_cd.html?eval=InvokeISP(),cdfile=" + instRoot;
}


function GetDisplayValue(id)
{
	var displayVal=null;

	if(top.document.debug && id!="online_support")
		id="debug";

	switch(id)
	{
		case "online_support":
			if(GetExpandValue('$MotiveInfo$'))
				displayVal="MotiveServ"
			else
				displayVal="EmailServ"
			break;

		case "register":
			var temp = new Object();

			InstallBroker.GetProcessString(GetMacroValue("INFIELD_DIR") +"\\inc.hpi", "ereg_langs", temp);
			if(!temp.value)
			{
				InstallBroker.GetProcessString("master.hpi","2",temp);
				InstallBroker.GetProcessString(temp.value + "\\inc.hpi","ereg_langs",temp);
			}

			var strEregLangs = temp.value.toLowerCase();
			var strLang = GetMacroValue("LANG").toLowerCase();

			if(strLang && (strEregLangs.indexOf(strLang) >=0))
				displayVal=true;
			else
				displayVal=false;
			break;

		case "printSample":
	  		var result = new Object();
			var sampleExt;
	  		result.value=false;

			if(GetMacroValue("SLEEK")=="true")
				sampleExt=".ldl";
			else
				sampleExt=".pcl";

	  		InstallBroker.CheckFileExists(GetMacroValue("INSTALLDIR") + "\\" + GetMacroValue("PROD") + "\\sample1" + sampleExt, result);
			if(result.value != false)
				displayVal=true;
			else
				displayVal=false;
			break;

		case "isp_offer":
			if(ProcessSysInfoItem("WindowsVersion").match(/^Microsoft\s+Windows\s+(95|98$)/i))
				displayVal=false;
			else
			{
				var isp_offer=GetMacroValue("HP_ISP_AVAILABLE");

				if(isp_offer.toLowerCase()=="true")
					displayVal=true;
				else
					displayVal=false;
			}
			break;

		case "debug":
			displayVal=true;
			break;

		default:
			displayVal=false;
	}

	return displayVal;
}


// ===========================================
// Added features for software install
// ===========================================
var ISW_Timeout_ID=null;
function InstallSoftware(hpi,softwareName)
{
	if(ISW_Timeout_ID)
	    clearTimeout(ISW_Timeout_ID);

	if(IsCDInserted())
	{
		if(top.document.URL.match(/warn_insert_cd.html/i))
		{
			var elementObj=GetElementFromPath("div:okButton,img");
			if(elementObj)
			{
				elementObj.parentNode.removeChild(elementObj);
				elementObj=GetElementFromPath("div:okButton,a")
				if(elementObj)
				{
					elementObj.setAttribute("id","link")
					elementObj=GetElementFromPath("div:okButton,a,img")
					elementObj.setAttribute("style","link")
					//elementObj.setAttribute("onclick","InstallSoftware()")
				}
			}
		}

		var args=GetQueryStringArgs();

		if(args && (!hpi || !softwareName))
		{
			hpi=args.hpi;
			softwareName=args.swname;
		}

		if(hpi && softwareName)
		{
		    InstallBroker.InitProcess( null, false );
		        
		    // set product and lang
		    InstallBroker.SetProcessString( "product", GetMacroValue("PROD"));
		    InstallBroker.SetProcessString( "lang", GetMacroValue("LANG"));

	        if (hpi == 'master.hpi') 
	        {  
		        //quickHelp for alternate localization language PDF
		        InstallBroker.SetProcessString('alt_lang_pdf',softwareName);
		        InstallBroker.Process(GetMacroValue("INFIELD_DIR") + "\\master.hpi",'view_alt_lang_pdf');
		    }
		    else
		    {
		         //3rd party software install
		        InstallBroker.Process(GetMacroValue("INFIELD_DIR")+ "\\" + hpi,softwareName);
		    }
		}
		else if(args.eval)
		{
			try{eval(args.eval)}catch(e){}
		}

		top.back();
    }
    else if(!top.document.URL.match(/warn_insert_cd.html/i))
    {
	    InstallBroker.InitProcess( null, false );
	    InstallBroker.SetProcessString( "product", GetMacroValue("PROD"));
	    InstallBroker.SetProcessString( "lang", GetMacroValue("LANG"));

        InstallBroker.DisableAutoRun();
        top.location.href = "warn_insert_cd.html?"+"hpi="+hpi+","+"swname="+softwareName;
    }
	else
		ISW_Timeout_ID = setTimeout('InstallSoftware()',1000);
}  


function IsCDInserted(fileToCheck)
{
    var result=new Object();
    result.value = false;

	if(fileToCheck)
	  	InstallBroker.CheckFileExists(fileToCheck, result);
	else
	{
		var args=GetQueryStringArgs();
		if(args.cdfile)
		  	InstallBroker.CheckFileExists(args.cdfile, result);
		else
		  	InstallBroker.CheckFileExists(GetMacroValue("CDROOT") + "\\hpsetup.ini", result);
	}
  	
  	return result.value;
}


function GetQueryStringArgs()
{
	var args = new Object();
	if(top.document.URL.match(/\?([^\?]+)$/))
	{
		var query=RegExp.$1; 		//get query string.
		var pairs = query.split(",");				//break at comma.

		for (var i=0; i< pairs.length; i++) 
		{
			keyval=unescape(pairs[i])
			if(keyval.match(/^([^=]+)=(.+)$/))
			{
				//LogMessage(0,"key:" + RegExp.$1 + " | value:" + RegExp.$2)
				args[RegExp.$1]=RegExp.$2
			}
		}
	}

	return args;		
}
