function showNavigationEx(color,buttonInfoList,keyString)
{
	var iface = new ButtonInterface();
	var currentUrl=null;
	if(top.history.current.match(/([^\/\\]+)$/))
		currentUrl=RegExp.$1;

	for(var i=0;i<ButtonInfo.length;i++)
	{
		var dimOnPageNamed="";
   		var btn = new PAButton(color, ButtonInfo[i][0]);
		for(var j=1;j<ButtonInfo[i].length;j++)
	   	{
			if(ButtonInfo[i][j].length > 1)
			{
				if(ButtonInfo[i][j][0]=="display" && top.document.debug)
					ButtonInfo[i][j][1]=true;

				if(ButtonInfo[i][j][0]=="dimOnPageNamed")
					dimOnPageNamed=null;
					
				if(ButtonInfo[i][j][0].match(/^link(-noreplace)?$/) && dimOnPageNamed!=null)
					dimOnPageNamed=ButtonInfo[i][j][1];						

				if(ButtonInfo[i][j][0]=="link" &&
					!ButtonInfo[i][j][1].match(/_fs.html$/i) &&
					buttonInfoList.sectionHome &&
					(currentUrl.toLowerCase() != buttonInfoList.sectionHome.toLowerCase()))
				{
					ButtonInfo[i][j][0]="onClickAttribute";
					ButtonInfo[i][j][1]="top.location.replace('" + ButtonInfo[i][j][1] + "')";
				}

				if(ButtonInfo[i][j][0].match(/^link-noreplace$/))
					ButtonInfo[i][j][0]="link";
				
				if(ButtonInfo[i][j][0]!="displayWhen" || !top.document.debug)
					btn[ButtonInfo[i][j][0]]=ButtonInfo[i][j][1]
			}
		}

		if(dimOnPageNamed)
			btn.dimOnPageNamed=dimOnPageNamed;

		iface.addButton(btn)
	}

	if(keyString)
		iface.addKey(keyString)

	iface.draw();

	PreloadImages("b_" + color + "Btn2.gif");
}


//========================== ButtonInterface ==============================

function ButtonInterface() {
   // Properties
   this.buttonList = new Array();
   this.keys = new String(".");
   
   this.evaluator = new BoolLogicEval();
   
   // Methods
   this.draw = buttonInterfaceDraw;
   this.addButton = buttonInterfaceAddButton;
   this.addKey = buttonInterfaceAddKey;
   this.evalKeys = buttonInterfaceEvalKeys;
}

//............................... methods .................................

function buttonInterfaceDraw() { with (this) {
   var nextNdx = 1;
   var ndx;
   var expr = new String();
   var btn = null;
   
   for (ndx = 0; ndx < buttonList.length; ndx++) {
      btn = buttonList[ndx];
      
      var show = (btn.display != null)?btn.display:true;
      var dim = false;
      
      if (btn.displayWhen.length>0 && btn.display == null) {
         evaluator.expr = evalKeys(btn.displayWhen);
         evaluator.autoFormat();
         show = evaluator.doEval();
         //dump("show evaluator: " + ndx + " " + show);
      }
      if (btn.dimWhen.length>0 && btn.dimmed == null) {
         evaluator.expr = evalKeys(btn.dimWhen);
         evaluator.autoFormat();
         dim = evaluator.doEval();
         //dump("dim evaluator: " + ndx + " " + dim);
      }
      
      //dump("show: " + show + "; btn.display: " + btn.display);
      
      if (show == true) {
         if (dim == 1) {
            //dump("setting btn.dimmed = true");
            btn.dimmed = true;
         }
         btn.number = nextNdx++;
         //dump("Added Button #" + btn.number + ".");
      }
      else {
         btn.number = 0;
      }
   }
   
   for (ndx = 0; ndx < buttonList.length; ndx++) {
      buttonList[ndx].draw();
   }

   // Draw Swoosh
   var numButtons = 0;
   for (var ndx = 0; ndx < buttonList.length; ndx++) {
      if (buttonList[ndx].number>0)
         numButtons++;
   }
   var imageName="images/b_background" + numButtons + ".gif"

	var divElement=document.createElement("div");
	divElement.setAttribute("id","swoosh");
		
	var imgElement=document.createElement("img");
	imgElement.setAttribute("src",imageName);
	imgElement.setAttribute("width","70");
	imgElement.setAttribute("height","480");

	divElement.appendChild(imgElement);

	var body=document.getElementsByTagName("body").item(0);
	body.appendChild(divElement);
}};

//.........................................................................

function buttonInterfaceAddButton(btn) { with (this) {
   buttonList.push(btn);
}};

//.........................................................................

function buttonInterfaceAddKey(key) { with (this) {
   keys += key + ".";
}};

//.........................................................................

function buttonInterfaceEvalKeys(btnExpr) {
   // 1 ignore until non-operator
   // 2 read to buffer until operator
   // 3 check buffer against keys
   // 4 return to 1
   var master = new String();
   var ndx = 0;
   var buffer = new String();
   var cur = btnExpr.charAt(ndx);
   
   while (ndx < btnExpr.length) {
      //dump("cur = " + cur);
      while ((ndx < btnExpr.length) && (cur != "|") && (cur != "&") && (cur != "!") && (cur != "(") && (cur != ")")) {
         buffer += cur;
         //dump("buffered: " + cur);
         cur = btnExpr.charAt(++ndx);
      }
      if (buffer.length) {
         //dump("buffer:" + buffer);
         if (this.keys.indexOf("." + buffer + ".")>=0)
            master += "1";
         else
            master += "0";
         buffer = "";
      }
      master += cur;
      cur = btnExpr.charAt(++ndx);
   }
   
   //dump(btnExpr + ": " + master);
   return master;
};


//============================== PAButton =================================

function PAButton(theColor, theLabel) {
   this.parent = Button;
   this.parent();
   delete this.parent;
   
   // New PAButton Attributes
   this.color = theColor;
   
   // Overridden ButtonAttributes
   this.label = theLabel;    // Label text
   this.labelClass = new String("buttonLabels"); // Style sheet class
   this.labelIdPrototype = "buttonLabel#B";
   this.labelWidth = new Number(115);           // Width of table cell
   this.labelHeight = new Number(50);           // Height of table cell
   
   this.imageIdPrototype = "Button#B";        // ex: Button#B -> Button1B, Button2B
   
   this.defaultImage = "images/b_" + this.color + "Btn1.gif";      // "default" image
   this.overImage = "images/b_" + this.color + "Btn2.gif";         // "mouseOver" image
   this.dimImage = "images/b_" + this.color + "Btn3.gif";          // "disabled" image
};


//............................... methods .................................

function PAButtonDraw() { with (this) {
   parent.draw();
}};


//=============================== Button ==================================

function Button() {
   // Properties
   this.label = new String();                   // Label text
   this.labelClass = new String();              // Style sheet class
   this.labelId = new String();                 // Style sheet id
   this.labelIdPrototype = new String();        // Similar to locPrototype
   this.labelWidth = new Number();              // Width of table cell
   this.labelHeight = new Number();             // Height of table cell
   
   this.link = new String();                 // link to page to display when image is clicked
   this.wildCard = new String("#");             // character to be swapped in "prototypes"
   
   this.imageId = new String();                 // Style sheet reference
   this.imageIdPrototype = new String();        // ex: Button#A -> Button1A, Button2A
   this.imageWidth = new Number(0);             // image width, not set when 0
   this.imageHeight = new Number(0);            // image height, not set when 0
   this.number = new Number(1);                 // Put in place of # or wildCard in prototypes
   
   this.defaultImage = new String();      // "default" image
   this.overImage = new String();         // "mouseOver" image
   this.outImage = new String();          // "mouseOut" image
   this.downImage = new String();         // "mouseDown" image
   this.upImage = new String();           // "upImage" image
   this.clickImage = new String();        // "onClick" image
   this.dimImage = new String();          // "disabled" image
   
   this.dimOnPageNamed = new String();    // file name of page btn shows as dim on
   this.dimOnPageTitled = new String();   // title of page btn shows as dim on
   this.displayWhen = new String();       // ex: (AlignServ||CalibrateServ)
   this.display = null;                   // sets visibility of the button
   this.dimWhen = new String();           // ex: (!AlignServ&&!CalibrateServ)
   this.dimmed = null;                    // if set to true button is always dimmed
   
   this.overHandler = new String();
   this.outHandler = new String();
   this.downHandler = new String();
   this.upHandler = new String();
   this.clickHandler = new String();
   this.onClickAttribute=null;
   
   // methods
   this.draw = buttonDraw;
   this.buildImageDiv = buttonBuildImageDiv;
   this.buildImageAnchor = buttonBuildImageAnchor;
   this.buildButtonImage = buttonBuildButtonImage;
   this.buildLabelDiv = buttonBuildLabelDiv;
   this.doButtonMouseOver = buttonDoButtonMouseOver;
   this.doButtonMouseOut = buttonDoButtonMouseOut;
   this.doButtonMouseDown = buttonDoButtonMouseDown;
   this.doButtonMouseUp = buttonDoButtonMouseUp;
   this.doButtonMouseClick = buttonDoButtonMouseClick;
};

//............................... methods .................................

function buttonDraw() { with (this) {
   //dump("drawing button number: " + number + "; prototype: " + labelIdPrototype);
   if (number>0 && display != false) {
      var body = document.body;
      
      // Get name of current HTML file and put in pageFileName
      //dump("href: " + document.URL);
      var pageUrl = document.URL.split("/");
      var pageFileName = pageUrl[pageUrl.length-1];
      //dump("pageFileName: " + pageFileName);
      
      if (dimmed == null) {
         //dump("Condition: dimmed == null");
         dimmed = (document.title == dimOnPageTitled) || (pageFileName == dimOnPageNamed);
      }
      
      var imgDiv = buildImageDiv();
      
      if (!dimmed)
         var a = buildImageAnchor();
      
      var img = buildButtonImage();
      
      var labelDiv = buildLabelDiv();
      
      if (!dimmed) {
         a.appendChild(img);
         imgDiv.appendChild(a);
      }
      else {
         imgDiv.appendChild(img);
      }
      body.appendChild(imgDiv);
      body.appendChild(labelDiv);
   }
}};


//.........................................................................

function buttonBuildImageDiv() { with (this) {
   var btnDiv = document.createElement("div");
   var classId = null;
   
   if (imageIdPrototype.length && !imageId.length) { // <- recently added second condition
      var ndx = imageIdPrototype.indexOf(wildCard);
      classId = imageIdPrototype.substring(0, ndx) + number + imageIdPrototype.substring(ndx+1, imageIdPrototype.length);
   }
   else {
      classId = imageId;
   }
   
   btnDiv.setAttribute("id", classId);
   
   return (btnDiv);
}};

//.........................................................................

function buttonBuildImageAnchor() { with (this) {
   var btnAnchor = document.createElement("a");
   var labelRet = label.replace(/<[^>]*>/gi,"");
   btnAnchor.setAttribute("alt", labelRet);

   if (link.length)
      btnAnchor.setAttribute("href", link);  // <- "link" may be reserved
   //btnAnchor.defaultImage = defaultImage;
   btnAnchor.btn = this;
   
   // PDA! Sol- No easy solution.
   //outImage = (outImage.length)?outImage:defaultImage;
   
   if (overImage.length || overHandler.length) {
      btnAnchor.onmouseover = doButtonMouseOver;
      btnAnchor.onmouseout = doButtonMouseOut;
   }
   if (downImage.length || downHandler.length) {
      btnAnchor.onmousedown = doButtonMouseDown;
      btnAnchor.onmouseup = doButtonMouseUp;
   }

	if(onClickAttribute)
		btnAnchor.setAttribute("onclick",onClickAttribute);
	else if (clickImage.length || clickHandler.length)
		btnAnchor.onclick = doButtonMouseClick;

	btnAnchor.setAttribute("id","link");

   /*if (dimImage.length) {
      btnAnchor.dimImage = dimImage;
   }*/
   
   //-dump("Built anchor. (buildButtonAnchor)");
   
   return (btnAnchor);
}};

//.........................................................................

function buttonBuildButtonImage() { with (this) {
   var btnImg = document.createElement("img");
   btnImg.setAttribute("id", "btnImg" + number);
   btnImg.setAttribute("name", label);
   btnImg.setAttribute("border", "0");
   
   if (!dimmed) {
      btnImg.setAttribute("src", defaultImage);
      btnImg.setAttribute("id", "link");
   }
   else
      btnImg.setAttribute("src", dimImage);
   if (imageWidth>0)
      btnImg.setAttribute("width", imageWidth);
   if (imageHeight>0)
      btnImg.setAttribute("height", imageHeight);
      
   return (btnImg);
}};

//.........................................................................

function buttonBuildLabelDiv() { with (this) {
   var labelDiv = document.createElement("div");
   
   if (label.length)
   {
	var divId = null;
	while(label.match(/\&(#\d+|\w+);/))
	{
		if(RegExp.$1[0]=="#")
		{
			var charCode=Number(RegExp.$1.slice(1))
			label=label.replace(/&#\d+;/,String.fromCharCode(charCode));
		}
		else
		{
			label=label.replace(/\&amp;/g,"&");
			label=label.replace(/\&lt;/g,"<");
			label=label.replace(/\&gt;/g,">");
			label=label.replace(/\&apos;/g,"'");
			label=label.replace(/\&quot;/g,'"');
		}
	}

      if (labelIdPrototype.length && !labelId.length) { // <- Newly added, not tested
         var ndx = labelIdPrototype.indexOf(wildCard);
         var ndx = labelIdPrototype.indexOf("#");
         divId = labelIdPrototype.substring(0, ndx) + number + labelIdPrototype.substring(ndx+1, labelIdPrototype.length);
      }
      else {
         divId = labelId;
      }
      
      labelDiv.setAttribute("id", divId);
      
      //does label text have a <br/> node in it?
      var textSplit = label.split(/\s*<BR\/>\s*/i);

      var text = new Array(); //text node array

      if(textSplit != null)
      {
        text[0]=document.createTextNode(textSplit[0]);

        for(var i=1; i < textSplit.length; i++)
        {
           text[i] = document.createTextNode(textSplit[i]);  
        }
      }
      else
         text[0] = document.createTextNode(label);
        
      
      if ((labelWidth>0) || (labelHeight>0)) {
         var table = document.createElement("table");
         table.setAttribute("width", labelWidth);
         
         var td = document.createElement("td");
         td.setAttribute("class", labelClass);
         td.setAttribute("height", labelHeight);
         td.setAttribute("valign", "middle");
         //td.appendChild(text);
         for( var i = 0; i < text.length; i++)
         {
            if(i != 0) td.appendChild(document.createElement("br"));
            td.appendChild(text[i]);
         }


         table.appendChild(td);
         labelDiv.appendChild(table);
      }
      else {
         labelDiv.setAttribute("class", labelClass);
         for( var i = 0; i < text.length; i++)
         {
            if(i != 0) labelDiv.appendChild(document.createElement("br"));
            labelDiv.appendChild(text[i]);
         }
      }
   }
   return (labelDiv);
}};

//.........................................................................

function buttonDoButtonMouseOver(e) { with (this) {
   //dump("over: " + this.btn.overImage);
   if (btn.overImage.length)
      SwapImageEx(this,0,this.btn.overImage);
   if (btn.overHandler.length) {
      //dump(btn.overHandler + "(" + this + + ", " + this.btn + ");");
      eval(btn.overHandler + "(this, this.btn, 'over');");
   }
}};

//.........................................................................

function buttonDoButtonMouseOut(e) { with (this) {
   if (btn.overImage.length) {
      var output = (btn.outImage.length)?btn.outImage:btn.defaultImage;
      //dump("Out Ouptput: " + output);
      SwapImageEx(this,0,output);
   }
   if (btn.outHandler.length) {
      //dump(btn.overHandler + "(" + this + + ", " + this.btn + ");");
      eval(btn.outHandler + "(this, this.btn, 'out');");
   }
}};

//.........................................................................

function buttonDoButtonMouseDown(e) { with (this) {
   //dump("down: " + this.btn.downImage);
   if (btn.downImage.length)
      SwapImageEx(this,0,btn.downImage);
   if (btn.downHandler.length) {
      //dump(btn.overHandler + "(" + this + + ", " + this.btn + ");");
      eval(btn.downHandler + "(this, this.btn, 'down');");
   }
}};

//.........................................................................

function buttonDoButtonMouseUp(e) { with (this) {
   //dump("up: " + this.btn.upImage + "," + this);
   //btnAnchor.upImage = (upImage.length)?upImage:defaultImage;
   
   if (btn.downImage.length) {
      var output = (btn.upImage.length)?btn.upImage:btn.defaultImage;
      //dump("Ouptput: " + output);
      SwapImageEx(this,0,output);
   }
   if (btn.upHandler.length) {
      eval(btn.upHandler + "(this, this.btn, 'up');");
   }
}};

//.........................................................................

function buttonDoButtonMouseClick(e) { with (this) {
   //dump("click: " + this.btn.clickImage);
   if (btn.clickImage.length)
      SwapImageEx(this,0,this.btn.clickImage);
   if (btn.clickHandler.length) {
      eval(btn.clickHandler + "(this, this.btn, 'click');");
   }
}};

//=========================== BoolLogicEval ===============================
// BoolLogicEval - JavaScript Object implementation of a Boolean Logic Evaluator
//  Dependancies: none
//  Version 1.2: 8/15 - speed enhancement for algorithm
//  Version 1.1: 8/14 - speed enhancement for stack structure 
//  Version 1.0: 8/6 - all basic functionality completed
// 
// This object was initially designed to support the Homplate dynamic interface
// JavaScript library.
//
// Example inputs for evaluate:
// (1&1)
//   returns 1
// (1|0)
//   returns 1
// (!0|0)
//   returns 1
// ((1|0)|0)
//   returns 1
//
// (1&0)
//   returns 0
// (0|0)
//   returns 0
// (!0&!1)
//   returns 0

function BoolLogicEval(expr) {
   this.expr = expr;
   this.mode = 0;
};

//............................... methods .................................

function setMode(tmp) { with (this) {
   mode = tmp;
}};
BoolLogicEval.prototype.setMode = setMode;

function validate() { with (this) {
   // 1. no two bool operators in a row (&&, ||, !!)
   var prev = expr.charAt(0);
   var cur = expr.charAt(1);
   
   if (expr.indexOf("&&")>=0)
      dump("Warning: '" + expr + "' contans double operators '&&'");
   if (expr.indexOf("||")>=0)
      dump("Warning: '" + expr + "' contans double operators '||'");
   if (expr.indexOf("!!")>=0)
      dump("Warning: '" + expr + "' contans double operators '!!'");
   
   // 2. check parenthesis usage
   var bal = 0;
   
   if (expr.indexOf("(") < 0 && expr.indexOf(")") < 0)
      dump("Warning: '" + expr + "' has no parenthesis");
   
   for (var ndx2=0; ndx2<expr.length; ndx2++) {
      if (expr.charAt(ndx2) == "(")
         bal++;
      else if (expr.charAt(ndx2) == ")")
         bal--;
   }
   
   if (bal > 0)
      dump("Warning: '" + expr + "' missing a closing parenthesis");
   if (bal < 0)
      dump("Warning: '" + expr + "' missing an opening parenthesis");
}};
BoolLogicEval.prototype.validate = validate;

function autoFormat() { with (this) {
   // 1. no two bool operators in a row
   //    '&&->&', '||'->'|', '!!'->''
   // 2. fix simple parenthesis problems
   //    1|0->(1|0),
   
   var cur;
   var next;
   var newStr = String();
   
   if (expr.charAt(0) != "(")
      newStr = "(";
   
   for (var ndx=0; ndx<expr.length; ndx++) {
      cur = expr.charAt(ndx);
      next = expr.charAt(ndx+1)
      
      if (cur == "!" && next == "!") {
         ndx++;
      }
      else {
         newStr += cur;
      
         if ((cur == "&" && next == "&") || (cur == "|" && next == "|"))
            ndx++;
      }
   }
   
   if (expr.charAt(expr.length-1) != ")")
      newStr += ")";
      
   //dump("Reformatted: " + expr + " -> " + newStr);
   expr = newStr;
   validate();
}};
BoolLogicEval.prototype.autoFormat = autoFormat;

function doEval() { with (this) {
   if (mode>=1) {
      validate();
      if (mode==2)
         autoReformat();
   }
   
   var curNdx = 0;
   var stack = new Array();
   
   do {
      curChar = expr.substring(curNdx, curNdx+1);
      curNdx++;
      while (curChar != ')') {
         stack.push(curChar);
         //dump("push: " + stack);
         curChar = expr.substring(curNdx, curNdx+1);
         curNdx++;
      }
      
      str = new String();
      tmp = stack.pop();
      while (tmp != '(') {
         //dump("pop:  " + stack);
         str += tmp;
         tmp = stack.pop();
      }
      //dump("pop:  " + stack);
      if (stack.length>0) {
         stack.push(compute(str));
         //dump("push: " + stack);
      }
      else {
         //dump("returning...");
         return compute(str);
      }
   } while (stack.length>0);
}};
BoolLogicEval.prototype.doEval = doEval;

// 1 = true
// 0 = false
// Does not support 1|1|1, 0&1&1, etc.
function compute(s) { with (this) {
   //dump("compute: " + s);
   var arr;
   var rhs, lhs;
   
   if (s.indexOf('&') >= 0) {
      arr = s.split('&');
      lhs = arr[0];
      rhs = arr[1];
      if (((lhs == "1" || lhs == "0!")) && ((rhs == "1") || rhs == "0!")) {
         //dump("Computed " + s + " as 1.");
         return "1";
      }
      else {
         //dump("Computed " + s + " as 0.");
         return "0";
      }
   }
   else if (s.indexOf('|') >= 0) {
      arr = s.split('|');
      lhs = arr[0];
      rhs = arr[1];
      if (((lhs == "1" || lhs == "0!")) || ((rhs == "1") || rhs == "0!")) {
         //dump("Computed " + s + " as 1.");
         return "1";
      }
      else {
         //dump("Computed " + s + " as 1.");
         return "0";
      }
   }
   else if (s == "0!" || s == "1") {
      //dump("Computed " + s + " as 1.");
      return "1";
   }
   else if (s == "1!" || s == "0") {
      //dump("Computed " + s + " as 0." );
      return "0";
   }
   
   dump("Warning: 'compute' of 'BoolLogicEval' defaulted input '" + s + "' to '1'." );
   return "1";
}};
BoolLogicEval.prototype.compute = compute;