/*********************************************************************************************
 Note:
 This file is for page specific functions.  If you are creating generic, common functions
 that span most of the pages it should be put in common.js
*********************************************************************************************/

function HackersMenu()
{
    GetExpandValue("$RunHackersMenu$");
}

function ConfigPrintScreen(launch)
{
	var retval=false;
	var pspath=GetExpandValue("$RegistryLookup,Software\\Hewlett-Packard\\PrnScrn,PrnScrnModulePath$");
	
	if(pspath)
		pspath=pspath + "\\prnconf.exe";
	else
	{
		pspath=GetMacroValue("INSTALLDIR");
		pspath=pspath.replace(/[^\\]+$/,"hp print screen utility\\prnconf.exe");
	}
	
	if(pspath && GetExpandValue("$CheckFileExists," + pspath + "$"))
	{
		if(launch) GetExpandValue("$run," + pspath + "$");
		retval=true;
	}

	return retval;
}

function InvokeSWUpdate()
{
	var appPath=GetExpandValue("$RegistryLookup,Software\\Hewlett-Packard\\Swut,UpdateToolPath$");
	if(!appPath)
		appPath=GetExpandValue("$RegistryLookup,Software\\Hewlett-Packard\\Swut,StubPath$");

	if(appPath && GetExpandValue("$CheckFileExists," + appPath + "$"))
		GetExpandValue("$CreateProcess," + appPath + "$");
	else
		top.location="update_driver.html"
}

function InvokeUninstall()
{
	var uninstallCmd=GetMacroValue("UNINSTALLER");

	if(uninstallCmd.match(/msiexec/i))
		GetExpandValue("$CreateVisibleProcess," + uninstallCmd + "$");
	else
	{
		if(top.document.URL.match(/\?(.+)$/))
			uninstallCmd+=" -vforce_uninstall=" + RegExp.$1;

		GetExpandValue("$CreateProcess," + uninstallCmd + "$");
	}

	exitButton(true);
}

function DisplayJpnSpecificAccessory()
{
	lang = GetMacroValue("LANG").toLowerCase();
	
	if(lang =="jpn")
		elementPath = "BODY,TABLE,TR:non_jpn";
	else
		elementPath = "BODY,TABLE,TR:jpn";

	elmnt=GetElementFromPath(elementPath);

	if(elmnt)
		elmnt.parentNode.removeChild(elmnt);
	
}

function InvokeWebReg()
{	
	var prnInfo=ProcessSysInfoItem("PrinterInfo");
	var serialId=null

	prnInfo=prnInfo.replace(/;/g,"");
	
	if(prnInfo.match(/sn#=\s*([^\s;,]+)/i))
		serialId="&serialId=" + RegExp.$1;

	LoadJumpURL('webreg','HP',serialId);
}

function InvokeISP()
{
	var result=new Object();
	result.value=false;

	var instRoot= GetMacroValue("CDROOT") + "\\isp\\HPSdpAPP\\setup\\install.exe";

	if(IsCDInserted(instRoot))
		GetExpandValue('$CreateProcess,' + '"' + instRoot + '" ' + GetMacroValue("HP_ISP_CMDLINE") + "$");
	else
		top.location.href="warn_insert_cd.html?eval=InvokeISP(),cdfile=" + instRoot;
}

function ExecMotive()
{
	var retval=false;
	var programPath=GetExpandValue('$MotiveInfo$');

	if(programPath)
	{
		var params='" "' + programPath.replace(/hpis.+$/i,"hpis\\") + '" -sf$'
		retval=GetExpandValue('$CreateProcess,"' + programPath + params)
	}

	return retval;
}

function GetDisplayValue(id)
{
	var displayVal=null;

	if(top.document.debug && id!="online_support")
		id="debug";

	switch(id)
	{
		case "print_screen_config":
			displayVal=ConfigPrintScreen();
			break;

		case "online_support":
			if(GetExpandValue('$MotiveInfo$'))
				displayVal="MotiveServ"
			else
				displayVal="EmailServ"
			break;

		case "register":
			var strEregLangs = GetMacroValue("EREG_LANGS").toLowerCase();
			var strLang = GetMacroValue("LANG").toLowerCase();

			if(strEregLangs && strLang && (strEregLangs.indexOf(strLang) >=0))
				displayVal=true;
			else
				displayVal=false;
			break;

		case "printSample":
			var sampleExt;

			if(GetMacroValue("SLEEK")=="true")
				sampleExt=".ldl";
			else
				sampleExt=".pcl";

			if(GetExpandValue("$CheckFileExists," + GetMacroValue("INSTALLDIR") + "\\" + GetMacroValue("PROD") + "\\sample1" + sampleExt + "$"))
				displayVal=true;
			else
				displayVal=false;
			break;

		case "isp_offer":
			if(ProcessSysInfoItem("WindowsVersion").match(/^Microsoft\s+Windows\s+(NT|95|98$)/i))
				displayVal=false;
			else
			{
				var isp_offer=GetMacroValue("HP_ISP_AVAILABLE");

				if(isp_offer.toLowerCase()=="true")
					displayVal=true;
				else
					displayVal=false;
			}
			break;

		case "US_region":
			if(ProcessSysInfoItem("RegionInfo") == "united states")
				displayVal = true;
			else
				displayVal = false;
				
			break;			
		case "debug":
			displayVal=true;
			break;

		default:
			displayVal=false;
	}

	return displayVal;
}

function GetSysInfoItem(SysInfoItem)
{
	var retStr=ProcessSysInfoItem(SysInfoItem)

	if(retStr == "")
		retStr= "-------------"
	else
	{
		retStr=retStr.replace(/\n/g,"<P>");
		retStr=retStr.replace(/\,/g,"<BR>");
		retStr=retStr.replace(/\t/g," - ");
		retStr=retStr.replace(/\;/g,"");
	}

    return '<td width="60%" class="blockText">' + retStr + '</td>'
}

function DisplaySupportPhoneList(mode,ctrlNode)
{
	if(mode=="hide" && !top.document.debug)
	{
		var showList=true;
		var phonelist=GetElementFromPath("BODY,TABLE,TBODY");
		if(phonelist)
		{
			var elmntID=ProcessSysInfoItem("RegionInfo")

			if(elmntID)
			{
				var tablehead=GetElementFromPath("BODY,TABLE,THEAD");
				if(tablehead)
				{
					var elmnt=GetElementFromPath("BODY,TABLE,TBODY,TR:" + elmntID);
					var elmntctrl=GetElementFromPath("BODY,TABLE,THEAD,TR:phonelist_ctrl")

					if(elmnt && elmntctrl)
					{
						var extent;

						extent=elmnt.getAttribute("extent");
						if(extent)
							extent=parseInt(extent);
						else
							extent=1

						for(var i=1;elmnt && i<=extent;i++)
						{
							if(i != 1)
								elmnt=GetElementFromPath("BODY,TABLE,TBODY,TR:" + elmntID + i);								

							if(elmnt)
								tablehead.insertBefore(elmnt,elmntctrl)
						}							

						top.document.phonelist=phonelist
						phonelist.parentNode.removeChild(phonelist);
						showList=false;
					}						
				}
			}		
		}

		if(showList)
		{
			var elmntctrl=GetElementFromPath("BODY,TABLE,THEAD,TR:phonelist_ctrl")
			elmntctrl.parentNode.removeChild(elmntctrl);
		}		
	}
	else if(ctrlNode && top.document.phonelist)
	{
		var tableNode=ctrlNode;

		while(tableNode.parentNode)
		{
			tableNode=tableNode.parentNode;
			if(tableNode.nodeName=="TABLE")
				break;
		}

		ctrlNode.parentNode.removeChild(ctrlNode)
		if(tableNode && (tableNode.nodeName=="TABLE"))
			tableNode.appendChild(top.document.phonelist);

		LoadFocalIndex("reset");
	}
}

function HidePrintDemoButtons()
{
	var sampleExt;
	if(GetMacroValue("SLEEK")=="true")
		sampleExt=".ldl";
	else
		sampleExt=".pcl";

	// look for files that exist and if they don't then show the corresponding button
	for( var i = 1; i <= 2; i++ )
	{
	    // set dugout path to dugout directory + product subdirectory
	  	if(!GetExpandValue("$CheckFileExists," + GetMacroValue("INSTALLDIR") + "\\" + GetMacroValue("PROD") + "\\sample" + i + sampleExt + "$") && !top.document.debug)
			DisplayElement("div:printSample"+i,"hidden")
	}

	var button=GetElementFromPath("div:printSample1,button");
	if(GetElementFromPath("div:printSample2"))
	{
		if(button && button.getAttribute("alt"))
		{
			button.removeChild(button.firstChild);
			button.appendChild(document.createTextNode(button.getAttribute("alt")))
		}
	}
	else if(button)
		button.setAttribute("alt",button.firstChild.data);
}

// ===========================================
// Added features for software install
// ===========================================
var ISW_Timeout_ID=null;
function InstallSoftware(hpi,softwareName)
{
	var InstallBroker = Components.classes["@dugout/infield/instservice;1"].getService(Components.interfaces.IInstService);

	if(!InstallBroker)
		return;

	if(ISW_Timeout_ID)
	    clearTimeout(ISW_Timeout_ID);

	if(IsCDInserted())
	{
		if(top.document.URL.match(/warn_insert_cd.html/i))
		{
			var elementObj=GetElementFromPath("div:okButton,img");
			if(elementObj)
			{
				elementObj.parentNode.removeChild(elementObj);
				elementObj=GetElementFromPath("div:okButton,a")
				if(elementObj)
				{
					elementObj.setAttribute("id","link")
					elementObj=GetElementFromPath("div:okButton,a,img")
					elementObj.setAttribute("style","link")
					//elementObj.setAttribute("onclick","InstallSoftware()")
				}
			}
		}

		var args=GetQueryStringArgs();

		if(args && (!hpi || !softwareName))
		{
			hpi=args.hpi;
			softwareName=args.swname;
		}

		if(hpi && softwareName)
		{
		    InstallBroker.InitProcess( null, false );
		        
		    // set product and lang
		    InstallBroker.SetProcessString( "product", GetMacroValue("PROD"));
		    InstallBroker.SetProcessString( "lang", GetMacroValue("LANG"));

	        if (hpi == 'master.hpi') 
	        {  
		        //quickHelp for alternate localization language PDF
		        InstallBroker.SetProcessString('alt_lang_pdf',softwareName);
		        InstallBroker.Process(GetMacroValue("INFIELD_DIR") + "\\master.hpi",'view_alt_lang_pdf');
		    }
		    else
		    {
		         //3rd party software install
		        InstallBroker.Process(GetMacroValue("INFIELD_DIR")+ "\\" + hpi,softwareName);
		    }
		}
		else if(args.eval)
		{
			try{eval(args.eval)}catch(e){}
		}

		top.back();
    }
    else if(!top.document.URL.match(/warn_insert_cd.html/i))
    {
	    InstallBroker.InitProcess( null, false );
	    InstallBroker.SetProcessString( "product", GetMacroValue("PROD"));
	    InstallBroker.SetProcessString( "lang", GetMacroValue("LANG"));

        InstallBroker.DisableAutoRun();
        top.location.href = "warn_insert_cd.html?"+"hpi="+hpi+","+"swname="+softwareName;
    }
	else
		ISW_Timeout_ID = setTimeout('InstallSoftware()',1000);
}  


function IsCDInserted(fileToCheck)
{
	if(fileToCheck)
	  	return GetExpandValue("$CheckFileExists," + fileToCheck + "$");
	else
	{
		var args=GetQueryStringArgs();
		if(args.cdfile)
		  	return GetExpandValue("$CheckFileExists," + args.cdfile + "$");
		else
		  	return GetExpandValue("$CheckFileExists," + GetMacroValue("CDROOT") + "\\hpsetup.ini" + "$");
	}
}


function GetQueryStringArgs()
{
	var args = new Object();
	if(top.document.URL.match(/\?([^\?]+)$/))
	{
		var query=RegExp.$1; 		//get query string.
		var pairs = query.split(",");				//break at comma.

		for (var i=0; i< pairs.length; i++) 
		{
			keyval=unescape(pairs[i])
			if(keyval.match(/^([^=]+)=(.+)$/))
			{
				//LogMessage(0,"key:" + RegExp.$1 + " | value:" + RegExp.$2)
				args[RegExp.$1]=RegExp.$2
			}
		}
	}

	return args;		
}
