@echo off

SET choice=a

set EXE_FILE=not_defined
if EXIST ..\..\setup\hpzscr01.exe SET EXE_FILE=..\..\setup\hpzscr01.exe
if EXIST hpzscr01.exe SET EXE_FILE=hpzscr01.exe
if "%EXE_FILE%" == "not_defined" goto MISSING_SCRUBBER_EXE

set FILE_CDA=not_defined
if EXIST ..\..\setup\hposcr06.dat SET FILE_CDA=hposcr06.dat
if EXIST hposcr06.dat SET FILE_CDA=hposcr06.dat

set FILE_CDB=not_defined
if EXIST ..\..\setup\hposcr07.dat SET FILE_CDB=hposcr07.dat
if EXIST hposcr07.dat SET FILE_CDB=hposcr07.dat

echo ******************** Executing Level1 CleanUP *********************
echo The possible cause may be
echo 1. There was a communication Problem with the device while installing
echo 2. There was an error while printing or scanning
echo *******************************************************************
echo.
echo.
echo If you chose to UNINSTALL, Please do the following...
echo 1. Unplug the USB cable from the back of your HP All-in-One device
echo 2. After the cleanup finishes, restart your computer and wait for Windows 
echo    to start up
echo 3. Reconnect the USB cable to your HP All-in-One device and wait for the 
echo    installation process to finish
echo 4. Try printing a document to confirm functionality
echo.
echo.

if Windows_NT==%OS% GOTO WIN2K_XP
GOTO WIN9x_ME

:WIN2K_XP
echo Press ENTER to continue Uninstalling... 
echo              OR 
echo Press Q followed by ENTER to QUIT Uninstallation

SET /P Choice=

IF /I %choice:~0,1%==Q GOTO END_QUIT

GOTO DISPLAY

:WIN9x_ME
choice /C:cq Press Q to quit Uninstall OR press C to continue...
if ERRORLEVEL==2 GOTO END_QUIT
if ERRORLEVEL==1 GOTO DISPLAY

GOTO END_QUIT

:DISPLAY

if "%FILE_CDA%" == "not_defined" goto DAT_CDA
start /w %EXE_FILE% -datfile %FILE_CDA% -unattended -showdisconnect -nocopytotemp -d MsiUninstaller,TaskUninstaller,RemoveProgramUninstaller,ScannerUninstaller,AiONetworkDriveUninstaller,PrinterUninstaller,DriverUninstaller,ServiceUninstaller,PortUninstaller,RsmUninstaller,RegistryUninstaller,FileUninstaller,MonitorUninstaller,ProcessShutdown,WindowShutdown

:DAT_CDA

if "%FILE_CDB%" == "not_defined" goto DAT_CDB
start /w %EXE_FILE% -datfile %FILE_CDB% -unattended -showdisconnect -nocopytotemp -d MsiUninstaller,TaskUninstaller,RemoveProgramUninstaller,ScannerUninstaller,AiONetworkDriveUninstaller,PrinterUninstaller,DriverUninstaller,ServiceUninstaller,PortUninstaller,RsmUninstaller,RegistryUninstaller,FileUninstaller,MonitorUninstaller,ProcessShutdown,WindowShutdown

:DAT_CDB

goto END


:MISSING_SCRUBBER_EXE
echo "**** Uninstall file not found: hpzscr01.exe ****"
goto EXIT


:END
echo Uninstallation Completed.

:END_QUIT
echo DONE.
pause

:END_LAST


:EXIT