@echo off

SET choice=a

set SCRUBBER_EXE_FILE=not_defined
if EXIST ..\..\setup\hpzscr01.exe SET SCRUBBER_EXE_FILE=..\..\setup\hpzscr01.exe
if EXIST hpzscr01.exe SET SCRUBBER_EXE_FILE=hpzscr01.exe
if "%SCRUBBER_EXE_FILE%" == "not_defined" goto MISSING_SCRUBBER_EXE

set SCRUBBER_DAT_FILE=not_defined
if EXIST ..\..\setup\hphscr12.dat SET SCRUBBER_DAT_FILE=hphscr12.dat
if EXIST hphscr12.dat SET SCRUBBER_DAT_FILE=hphscr12.dat


if EXIST %TEMP%\PIPS3.tmp goto LEVEL4

echo ******************** Executing Level3 CleanUP *********************
echo This cleanup utility will remove the HP Image Zone software 
echo and the HP product drivers. Use this utility to remove software if you are
echo having a problem using the software and would like to reinstall the software
echo ********************************************************************
echo.
echo.
echo If you chose to UNINSTALL, Please do the following...
echo 1. Unplug the USB cable from the back of your HP Deskjet device
echo 2. After the cleanup finishes, restart your computer and wait for Windows to 
echo    start up
echo 3. Eject and re-insert the software CD that came with your HP Deskjet 
echo    device to start the installation
echo 4. Follow the on-screen instructions to finish the installation
echo 5. Try printing a document to confirm functionality
echo.
echo.

if Windows_NT==%OS% GOTO WIN2K_XP
GOTO WIN9x_ME

:WIN2K_XP
echo Press ENTER to continue Uninstalling... 
echo              OR 
echo Press Q followed by ENTER to QUIT uninstallation

SET /P Choice=

IF /I %choice:~0,1%==Q GOTO END_QUIT

GOTO DISPLAY

:WIN9x_ME
choice /C:cq Press Q to quit Uninstall OR press C to continue...
if ERRORLEVEL==2 GOTO END_QUIT
if ERRORLEVEL==1 GOTO DISPLAY

GOTO END_QUIT

:DISPLAY
REM IMAGE ZONE 5.3	
start /wait ..\..\setup\hpzscr01.exe -datfile hpqscr01.dat -unattended -nocopytotemp -noreboot
	
REM UNINSTALL Imaging Device Function
start /wait ..\..\setup\hpzscr01.exe -datfile hpqbud01.dat -unattended -nocopytotemp -noreboot

REM UNINSTALL Document Viewer
start /wait ..\..\setup\hpzscr01.exe -datfile hpqbud04.dat -unattended -nocopytotemp -noreboot
		
REM UNINSTALL Solution Center & Imaging Support Tool
start /wait ..\..\setup\hpzscr01.exe -datfile hpqbud05.dat -unattended -nocopytotemp -noreboot

REM UNINSTALL Customer Experience
start /wait ..\..\setup\hpzscr01.exe -datfile hpqbud06.dat -unattended -nocopytotemp -noreboot

REM UNINSTALL Remote Print
start /wait ..\..\setup\hpzscr01.exe -datfile hpqbud08.dat -unattended -nocopytotemp -noreboot
	
REM UNINSTALL Extended Capabilities
start /wait ..\..\setup\hpzscr01.exe -datfile hpqhsc01.dat -unattended -nocopytotemp -noreboot

REM UNINSTALL HP Software Update
start /wait ..\..\setup\hpzmsi01.exe -u {7BB3DC99-71DA-4FCB-B0ED-ACA161DBCA4B}

REM UNINSTALL HP Image Zone Express
start /wait ..\..\setup\hpzmsi01.exe -u {1DBA2633-55BD-42E2-BA81-EA4EBEC2CCF4}

REM UNINSTALL HP Tabasco Deskjet & Photosmart Series		
start /wait ..\..\setup\hpzscr01.exe -datfile %SCRUBBER_DAT_FILE% -unattended -showdisconnect -nocopytotemp -forcereboot

copy uninstall_L3.bat %TEMP%\PIPS3.tmp
goto END

:MISSING_SCRUBBER_DAT
echo "**** Uninstall file not found: hphscr??.dat ****"
goto EXIT

:MISSING_SCRUBBER_EXE
echo "**** Uninstall file not found: hpzscr01.exe ****"
goto EXIT

:LEVEL4
call Uninstall_L4.BAT
goto END_LAST

:END
echo Uninstallation Completed.

:END_QUIT
echo DONE.
pause

:END_LAST

:EXIT
