/*
 * Decompiled with CFR 0.152.
 */
package com.jolimark;

public class SerialPort {
    private static final String TAG = "SerialPort";
    private int Dev_fd = 0;

    static {
        System.loadLibrary(TAG);
    }

    public boolean Open(String Dev) {
        this.Dev_fd = SerialPort.OpenSerial(Dev);
        return this.Dev_fd >= 0;
    }

    public boolean Close() {
        int ret = 0;
        ret = this.CloseSerial(this.Dev_fd);
        return ret >= 0;
    }

    public boolean SetOption(int nSpeed, int nBits, char nEvent, int nStop) {
        int ret = 0;
        ret = this.SetSerialOpt(this.Dev_fd, nSpeed, nBits, nEvent, nStop);
        return ret >= 0;
    }

    public boolean SetBaudrate(int BaudRate) {
        int ret = 0;
        ret = this.SetSerialBaudrate(this.Dev_fd, BaudRate);
        return ret >= 0;
    }

    public long GetReadTimeOut() {
        return this.GetSerialReadTimeOut();
    }

    public boolean SetReadTimeOut(long ReadTimeOut) {
        int ret = 0;
        ret = this.SetSerialReadTimeOut(ReadTimeOut);
        return ret >= 0;
    }

    public String ReadString(int readLength) {
        int ret = 0;
        byte[] NewBuf = new byte[readLength];
        ret = this.ReadSerial(this.Dev_fd, NewBuf, readLength);
        if (ret > 0) {
            String rtnStr = new String(NewBuf);
            NewBuf = null;
            return rtnStr;
        }
        NewBuf = null;
        return null;
    }

    public byte[] ReadBuf(int readLength) {
        int ret = 0;
        byte[] NewBuf = new byte[readLength];
        ret = this.ReadSerial(this.Dev_fd, NewBuf, readLength);
        if (ret > 0) {
            return NewBuf;
        }
        return null;
    }

    public boolean WriteString(String sendStr) {
        int ret = 0;
        int len = sendStr.length();
        ret = this.WriteSerial(this.Dev_fd, sendStr.getBytes(), len);
        return ret > 0;
    }

    public boolean WriteBuf(byte[] sendBuf, int len) {
        int ret = 0;
        ret = this.WriteSerial(this.Dev_fd, sendBuf, len);
        return ret > 0;
    }

    public int GetUsbState() {
        return this.GetUsbState(this.Dev_fd);
    }

    public boolean IsUsbDevExists(String Dev) {
        return this.CheckUsbDevExists(Dev) > 0;
    }

    private static native int OpenSerial(String var0);

    private native int CloseSerial(int var1);

    private native int SetSerialOpt(int var1, int var2, int var3, char var4, int var5);

    private native int SetSerialBaudrate(int var1, int var2);

    private native long GetSerialReadTimeOut();

    private native int SetSerialReadTimeOut(long var1);

    private native int ReadSerial(int var1, byte[] var2, int var3);

    private native int WriteSerial(int var1, byte[] var2, int var3);

    private native int GetUsbState(int var1);

    private native int CheckUsbDevExists(String var1);
}

