/*
 * Decompiled with CFR 0.152.
 */
package com.jolimark;

import android.content.Context;
import com.jolimark.JmError;
import com.jolimark.SerialPort;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import jolimark.devices.DevGpio;

public class JmPrinter {
    static int BASE_ERR_CODE = 0;
    byte LastPrintERR = 0;
    SerialPort MyPrinter = new SerialPort();
    String DEVICE_NAME_PRINTER = "/dev/ttyS2";

    public JmPrinter() {
        this.MyPrinter.SetReadTimeOut(15000000L);
    }

    private static void initLibs1(Context mycontext) {
        InputStream in = null;
        try {
            in = mycontext.getResources().getAssets().open("XXXXX.zip");
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        File dir = mycontext.getDir("libs", 0);
        File soFile = new File(dir, "XXXXX.so");
        FileOutputStream out = null;
        try {
            int len;
            out = new FileOutputStream(soFile);
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            in.close();
            out.close();
            System.load(soFile.getAbsolutePath());
            soFile.delete();
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void initLibs2(Context mycontext) {
        InputStream in = null;
        try {
            in = mycontext.getResources().getAssets().open("XXXXX.zip");
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        File dir = mycontext.getDir("libs", 0);
        File soFile = new File(dir, "XXXXX.so");
        FileOutputStream out = null;
        try {
            int len;
            out = new FileOutputStream(soFile);
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            in.close();
            out.close();
            System.load(soFile.getAbsolutePath());
            soFile.delete();
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static void initLibrarys(Context mycontext) {
        JmPrinter.initLibs1(mycontext);
        JmPrinter.initLibs2(mycontext);
    }

    private void MyPerror(String Msg) {
    }

    public String GetLastPrintErr() {
        String errorStr = JmError.GetLastPrintErr(BASE_ERR_CODE);
        return errorStr;
    }

    public int GetLastPrintErrCode() {
        return BASE_ERR_CODE;
    }

    private int GetLastBaseErrCode(byte PrintErrCode) {
        if ((PrintErrCode & 2) != 0) {
            return 39;
        }
        if ((PrintErrCode & 8) != 0) {
            return 37;
        }
        if ((PrintErrCode & 4) != 0) {
            return 38;
        }
        if ((PrintErrCode & 0x20) != 0) {
            return 35;
        }
        if ((PrintErrCode & 0x40) != 0) {
            return 34;
        }
        if ((PrintErrCode & 0x10) != 0) {
            return 36;
        }
        if ((PrintErrCode & 0x80) != 0) {
            return 33;
        }
        if (PrintErrCode == 0) {
            return 32;
        }
        return 15;
    }

    private byte CheckSum(byte[] data, int len) {
        byte Sum = 0;
        int i = 0;
        while (i < len) {
            Sum = (byte)(Sum + data[i]);
            ++i;
        }
        return Sum;
    }

    private byte[] GenerateStr(byte CmdStype, byte[] Param, int ParamLen) {
        byte nSum = 0;
        int nStrLen = 0;
        nStrLen = 6 + ParamLen;
        byte[] RtnStr = new byte[nStrLen];
        RtnStr[0] = 27;
        RtnStr[1] = 16;
        RtnStr[2] = CmdStype;
        RtnStr[3] = (byte)(nStrLen >> 8 & 0xFF);
        RtnStr[4] = (byte)(nStrLen & 0xFF);
        int i = 0;
        while (i < ParamLen) {
            RtnStr[5 + i] = Param[i];
            ++i;
        }
        RtnStr[ParamLen + 5] = nSum = this.CheckSum(RtnStr, ParamLen + 5);
        return RtnStr;
    }

    private boolean ReadRestChar() {
        int tmpValue = BASE_ERR_CODE;
        byte[] rtnBuf = null;
        int ret = 0;
        rtnBuf = this.MyPrinter.ReadBuf(1);
        if (rtnBuf != null) {
            ret = rtnBuf.length;
        }
        BASE_ERR_CODE = tmpValue;
        rtnBuf = null;
        return ret > 0;
    }

    public boolean Open() {
        boolean ret = false;
        BASE_ERR_CODE = 0;
        try {
            ret = this.MyPrinter.Open(this.DEVICE_NAME_PRINTER);
            if (ret) {
                ret = this.MyPrinter.SetOption(57600, 8, 'N', 1);
            } else {
                this.MyPerror("\u6253\u5f00\u6253\u5370\u673a\u4e32\u53e3\u5931\u8d25!\n");
                BASE_ERR_CODE = 16;
            }
        }
        catch (Exception Ex) {
            return false;
        }
        return ret;
    }

    public boolean Close() {
        boolean ret = this.MyPrinter.Close();
        return ret;
    }

    private boolean SendPrintCMD(byte[] Buf, int len) {
        byte[] RecvBuf = null;
        boolean ret = this.MyPrinter.WriteBuf(Buf, len);
        if (!ret) {
            this.MyPerror("\u53d1\u9001\u6570\u636e\u5230\u6253\u5370\u673a\u5931\u8d25!\n");
            BASE_ERR_CODE = 17;
            return ret;
        }
        RecvBuf = this.MyPrinter.ReadBuf(1);
        boolean bl = ret = RecvBuf != null;
        if (RecvBuf != null) {
            this.LastPrintERR = RecvBuf[0];
        }
        RecvBuf = null;
        if (!ret) {
            this.MyPerror("\u7b49\u5f85\u6253\u5370\u673a\u8fd4\u56de\u6570\u636e\u8d85\u65f6!\n");
            BASE_ERR_CODE = 18;
            return false;
        }
        BASE_ERR_CODE = this.GetLastBaseErrCode(this.LastPrintERR);
        return (this.LastPrintERR & 0x6F) == 0;
    }

    private boolean SendPrintRdCMD(byte[] inBuf, int inLen, byte[] outBuf, int outLen) {
        byte[] tmpBuf = null;
        boolean ret = this.MyPrinter.WriteBuf(inBuf, inLen);
        if (!ret) {
            this.MyPerror("\u53d1\u9001\u6570\u636e\u5230\u6253\u5370\u673a\u5931\u8d25!\n");
            BASE_ERR_CODE = 17;
            return false;
        }
        if (outBuf == null || outLen > outBuf.length) {
            this.MyPerror("\u63a5\u6536\u7a7a\u95f4\u4e0d\u8db3!\n");
            BASE_ERR_CODE = 30;
            return false;
        }
        tmpBuf = this.MyPrinter.ReadBuf(outLen);
        boolean bl = ret = tmpBuf != null;
        if (tmpBuf == null || tmpBuf.length < outLen) {
            this.MyPerror("\u7b49\u5f85\u6253\u5370\u673a\u8fd4\u56de\u6570\u636e\u8d85\u65f6!\n");
            BASE_ERR_CODE = 18;
            return false;
        }
        int i = 0;
        while (i < outLen) {
            outBuf[i] = tmpBuf[i];
            ++i;
        }
        tmpBuf = null;
        return ret;
    }

    public boolean Back(int StepNum) {
        if (StepNum <= 0 || StepNum >= 49) {
            this.MyPerror("\u5411\u540e\u9000\u7eb8\u8d85\u51fa\u8303\u56f4!\n");
            BASE_ERR_CODE = 31;
            return false;
        }
        if (!this.Open()) {
            return false;
        }
        byte[] Param = new byte[]{(byte)StepNum};
        byte[] Buf = this.GenerateStr((byte)0, Param, 1);
        boolean RtnValue = this.SendPrintCMD(Buf, 7);
        Param = null;
        Buf = null;
        this.Close();
        return RtnValue;
    }

    public boolean Feed(int StepNum) {
        if (StepNum <= 0 || StepNum >= 255) {
            this.MyPerror("\u5411\u524d\u8fdb\u7eb8\u8d85\u51fa\u8303\u56f4!\n");
            BASE_ERR_CODE = 31;
            return false;
        }
        if (!this.Open()) {
            return false;
        }
        byte[] Param = new byte[]{(byte)StepNum};
        byte[] Buf = this.GenerateStr((byte)1, Param, 1);
        boolean RtnValue = this.SendPrintCMD(Buf, 7);
        Param = null;
        Buf = null;
        this.Close();
        return RtnValue;
    }

    public boolean PrintBID() {
        if (!this.Open()) {
            return false;
        }
        long tmpTimeOut = 0L;
        byte[] byArray = new byte[7];
        byArray[0] = 27;
        byArray[1] = 16;
        byArray[2] = 2;
        byArray[4] = 7;
        byArray[6] = 52;
        byte[] Buf = byArray;
        tmpTimeOut = this.MyPrinter.GetReadTimeOut();
        this.MyPrinter.SetReadTimeOut(28000000L);
        boolean ret = this.SendPrintCMD(Buf, 7);
        this.MyPrinter.SetReadTimeOut(tmpTimeOut);
        Buf = null;
        this.Close();
        return ret;
    }

    public boolean SetBID(int BID_Value) {
        if (BID_Value < 0 || BID_Value > 20) {
            this.MyPerror("BID\u503c\u8bbe\u7f6e\u8d85\u51fa\u8303\u56f4!!\n");
            BASE_ERR_CODE = 31;
            return false;
        }
        if (!this.Open()) {
            return false;
        }
        byte[] Param = new byte[]{(byte)BID_Value};
        byte[] Buf = this.GenerateStr((byte)3, Param, 1);
        boolean RtnValue = this.SendPrintCMD(Buf, 7);
        Param = null;
        Buf = null;
        this.Close();
        return RtnValue;
    }

    public boolean SelfCheck() {
        if (!this.Open()) {
            return false;
        }
        long tmpTimeOut = 0L;
        byte[] byArray = new byte[7];
        byArray[0] = 27;
        byArray[1] = 16;
        byArray[2] = 4;
        byArray[4] = 7;
        byArray[6] = 54;
        byte[] Buf = byArray;
        tmpTimeOut = this.MyPrinter.GetReadTimeOut();
        this.MyPrinter.SetReadTimeOut(28000000L);
        boolean ret = this.SendPrintCMD(Buf, 7);
        this.MyPrinter.SetReadTimeOut(tmpTimeOut);
        Buf = null;
        this.Close();
        return ret;
    }

    public boolean BlackCheck() {
        if (!this.Open()) {
            return false;
        }
        byte[] byArray = new byte[7];
        byArray[0] = 27;
        byArray[1] = 16;
        byArray[2] = 5;
        byArray[4] = 7;
        byArray[6] = 55;
        byte[] Buf = byArray;
        boolean ret = this.SendPrintCMD(Buf, 7);
        Buf = null;
        if (this.LastPrintERR != 0 && (this.LastPrintERR & 4) != 4) {
            this.ReadRestChar();
        }
        this.Close();
        return ret;
    }

    public boolean GetStatus(byte[] StatusValue) {
        if (StatusValue == null || StatusValue.length < 1) {
            this.MyPerror("\u63a5\u6536\u7a7a\u95f4\u4e0d\u8db3!\n");
            BASE_ERR_CODE = 30;
            return false;
        }
        if (!this.Open()) {
            return false;
        }
        byte[] byArray = new byte[7];
        byArray[0] = 27;
        byArray[1] = 16;
        byArray[2] = 6;
        byArray[4] = 7;
        byArray[6] = 56;
        byte[] Buf = byArray;
        byte[] tmpRecBuf = new byte[2];
        boolean ret = this.SendPrintRdCMD(Buf, 7, tmpRecBuf, 1);
        if (ret) {
            StatusValue[0] = tmpRecBuf[0];
            this.ReadRestChar();
        }
        Buf = null;
        tmpRecBuf = null;
        this.Close();
        return ret;
    }

    public boolean PrintText2(byte[] BufStr, int millisecond) {
        if (BufStr == null) {
            this.MyPerror("\u6253\u5370\u6570\u636e\u6307\u9488\u4e3a\u7a7a!\n");
            BASE_ERR_CODE = 21;
            return false;
        }
        if (!this.Open()) {
            return false;
        }
        int ms = millisecond * 1000;
        this.MyPrinter.SetReadTimeOut(ms);
        int nStrlen = 0;
        nStrlen = BufStr.length;
        byte[] Buf = this.GenerateStr((byte)7, BufStr, nStrlen);
        boolean RtnValue = this.SendPrintCMD(Buf, nStrlen + 6);
        Buf = null;
        this.Close();
        if (this.LastPrintERR != 0) {
            return false;
        }
        return RtnValue;
    }

    public boolean PrintText(byte[] BufStr) {
        if (BufStr == null) {
            this.MyPerror("\u6253\u5370\u6570\u636e\u6307\u9488\u4e3a\u7a7a!\n");
            BASE_ERR_CODE = 21;
            return false;
        }
        if (!this.Open()) {
            return false;
        }
        int nStrlen = 0;
        nStrlen = BufStr.length;
        byte[] Buf = this.GenerateStr((byte)7, BufStr, nStrlen);
        boolean RtnValue = this.SendPrintCMD(Buf, nStrlen + 6);
        Buf = null;
        this.Close();
        if (this.LastPrintERR != 0) {
            return false;
        }
        return RtnValue;
    }

    public boolean PrintText1(byte[] BufStr) {
        if (BufStr == null) {
            this.MyPerror("\u6253\u5370\u6570\u636e\u6307\u9488\u4e3a\u7a7a!\n");
            BASE_ERR_CODE = 21;
            return false;
        }
        int nStrlen = 0;
        nStrlen = BufStr.length;
        byte[] Buf = this.GenerateStr((byte)7, BufStr, nStrlen);
        boolean RtnValue = this.SendPrintCMD(Buf, nStrlen + 6);
        Buf = null;
        if (this.LastPrintERR != 0) {
            return false;
        }
        return RtnValue;
    }

    public boolean PrintPic(byte[] BufStr) {
        if (BufStr == null) {
            this.MyPerror("\u6253\u5370\u6570\u636e\u6307\u9488\u4e3a\u7a7a!\n");
            BASE_ERR_CODE = 21;
            return false;
        }
        if (!this.Open()) {
            return false;
        }
        int nStrlen = 0;
        nStrlen = BufStr.length;
        byte[] Buf = this.GenerateStr((byte)8, BufStr, nStrlen);
        boolean RtnValue = this.SendPrintCMD(Buf, nStrlen + 6);
        Buf = null;
        this.Close();
        return RtnValue;
    }

    public boolean GetBlackValue(int[] BlackValue) {
        if (BlackValue == null || BlackValue.length < 1) {
            this.MyPerror("\u63a5\u6536\u7a7a\u95f4\u4e0d\u8db3!\n");
            BASE_ERR_CODE = 30;
            return false;
        }
        if (!this.Open()) {
            return false;
        }
        byte[] byArray = new byte[7];
        byArray[0] = 27;
        byArray[1] = 16;
        byArray[2] = 9;
        byArray[4] = 7;
        byArray[6] = 59;
        byte[] Buf = byArray;
        byte[] tmpRecBuf = new byte[2];
        boolean ret = this.SendPrintRdCMD(Buf, 7, tmpRecBuf, 1);
        if (ret) {
            BlackValue[0] = tmpRecBuf[0] & 0xFF;
            this.ReadRestChar();
        }
        Buf = null;
        tmpRecBuf = null;
        this.Close();
        return ret;
    }

    public boolean SetBlackValue(int BlackValue) {
        if (BlackValue <= 16 || BlackValue >= 128) {
            this.MyPerror("\u9ed1\u6807\u8c03\u6574\u8d85\u51fa\u8303\u56f4!\n");
            BASE_ERR_CODE = 31;
            return false;
        }
        if (!this.Open()) {
            return false;
        }
        byte[] Param = new byte[]{(byte)BlackValue};
        byte[] Buf = this.GenerateStr((byte)10, Param, 1);
        boolean RtnValue = this.SendPrintCMD(Buf, 7);
        Param = null;
        Buf = null;
        this.Close();
        return RtnValue;
    }

    public boolean SetBlackMode(int mode) {
        if (mode != 1 && mode != 0) {
            this.MyPerror("\u53c2\u6570\u9519\u8bef!\n");
            BASE_ERR_CODE = 31;
            return false;
        }
        if (!this.Open()) {
            return false;
        }
        byte[] Buf = new byte[]{27, 29, 30, 5, 1, 27, 29, 31, 27, 29, 30, 4, 34, 1, 27, 29, 31, 27, 29, 30, 5, 2, 27, 29, 31};
        Buf[13] = (byte)mode;
        boolean RtnValue = this.SendPrintCMD(Buf, Buf.length);
        Buf = null;
        this.Close();
        return RtnValue;
    }

    public boolean SetCharWH(byte BitValue) {
        if (!this.Open()) {
            return false;
        }
        byte[] Param = new byte[]{BitValue};
        byte[] Buf = this.GenerateStr((byte)11, Param, 1);
        boolean RtnValue = this.SendPrintCMD(Buf, 7);
        Param = null;
        Buf = null;
        this.Close();
        return RtnValue;
    }

    public boolean SelectPrintRange(int SelM) {
        if (!this.Open()) {
            return false;
        }
        boolean ret = false;
        byte[] byArray = new byte[7];
        byArray[0] = 27;
        byArray[1] = 16;
        byArray[2] = 12;
        byArray[4] = 7;
        byArray[6] = 62;
        byte[] Buf1 = byArray;
        byte[] byArray2 = new byte[7];
        byArray2[0] = 27;
        byArray2[1] = 16;
        byArray2[2] = 12;
        byArray2[4] = 7;
        byArray2[5] = 1;
        byArray2[6] = 63;
        byte[] Buf2 = byArray2;
        byte[] Buf = null;
        switch (SelM) {
            case 0: {
                Buf = Buf1;
                break;
            }
            case 1: {
                Buf = Buf2;
                break;
            }
            default: {
                Buf = null;
            }
        }
        if (Buf != null) {
            ret = this.SendPrintCMD(Buf, 7);
        } else {
            this.MyPerror("76/57mm\u6253\u5370\u8303\u56f4\u9009\u62e9\u8d85\u51fa\u8303\u56f4!\n");
            BASE_ERR_CODE = 31;
        }
        Buf1 = null;
        Buf2 = null;
        this.Close();
        return ret;
    }

    public boolean SetPrintSpeed(int SpeedSel) {
        if (!this.Open()) {
            return false;
        }
        boolean ret = false;
        byte[] byArray = new byte[7];
        byArray[0] = 27;
        byArray[1] = 16;
        byArray[2] = 13;
        byArray[4] = 7;
        byArray[6] = 63;
        byte[] Buf1 = byArray;
        byte[] byArray2 = new byte[7];
        byArray2[0] = 27;
        byArray2[1] = 16;
        byArray2[2] = 13;
        byArray2[4] = 7;
        byArray2[5] = 1;
        byArray2[6] = 64;
        byte[] Buf2 = byArray2;
        byte[] Buf = null;
        switch (SpeedSel) {
            case 0: {
                Buf = Buf1;
                break;
            }
            case 1: {
                Buf = Buf2;
                break;
            }
            default: {
                Buf = null;
            }
        }
        if (Buf != null) {
            ret = this.SendPrintCMD(Buf, 7);
        } else {
            this.MyPerror("\u6253\u5370\u901f\u5ea6\u9009\u62e9\u8d85\u51fa\u8303\u56f4!\n");
            BASE_ERR_CODE = 31;
        }
        Buf1 = null;
        Buf2 = null;
        this.Close();
        return ret;
    }

    public boolean SetStartPos(int BeginValue) {
        if (!this.Open()) {
            return false;
        }
        if (BeginValue < 0 || BeginValue > 7) {
            this.MyPerror("\u6253\u5370\u8d77\u59cb\u4f4d\u8bbe\u5b9a\u8d85\u51fa\u8303\u56f4!\n");
            BASE_ERR_CODE = 31;
            return false;
        }
        byte[] Param = new byte[]{(byte)BeginValue};
        byte[] Buf = this.GenerateStr((byte)14, Param, 1);
        boolean RtnValue = this.SendPrintCMD(Buf, 7);
        Param = null;
        Buf = null;
        this.Close();
        return RtnValue;
    }

    public boolean Inialize() {
        if (!this.Open()) {
            return false;
        }
        byte[] byArray = new byte[7];
        byArray[0] = 27;
        byArray[1] = 16;
        byArray[2] = 15;
        byArray[4] = 7;
        byArray[6] = 65;
        byte[] Buf = byArray;
        boolean ret = this.SendPrintCMD(Buf, 7);
        Buf = null;
        this.Close();
        return ret;
    }

    public boolean ContinuePrint() {
        if (!this.Open()) {
            return false;
        }
        byte[] byArray = new byte[7];
        byArray[0] = 27;
        byArray[1] = 16;
        byArray[2] = 16;
        byArray[4] = 7;
        byArray[6] = 66;
        byte[] Buf = byArray;
        boolean ret = this.SendPrintCMD(Buf, 7);
        Buf = null;
        this.Close();
        return ret;
    }

    public boolean PrintPinTest() {
        if (!this.Open()) {
            return false;
        }
        byte[] byArray = new byte[7];
        byArray[0] = 27;
        byArray[1] = 16;
        byArray[2] = 17;
        byArray[4] = 7;
        byArray[6] = 67;
        byte[] Buf = byArray;
        boolean ret = this.SendPrintCMD(Buf, 7);
        Buf = null;
        this.Close();
        return ret;
    }

    public boolean SetVolLimit(int N) {
        if (!this.Open()) {
            return false;
        }
        if (N < 0 || N >= 175) {
            this.MyPerror("\u7535\u538b24V\u68c0\u6d4b\u9600\u503c\u8bbe\u7f6e\u8d85\u51fa\u8303\u56f4!\n");
            BASE_ERR_CODE = 31;
            return false;
        }
        byte[] Param = new byte[]{(byte)N};
        byte[] Buf = this.GenerateStr((byte)18, Param, 1);
        boolean RtnValue = this.SendPrintCMD(Buf, 7);
        Param = null;
        Buf = null;
        this.Close();
        return RtnValue;
    }

    public boolean Restet() {
        if (!this.Open()) {
            return false;
        }
        byte[] byArray = new byte[7];
        byArray[0] = 27;
        byArray[1] = 16;
        byArray[2] = 19;
        byArray[4] = 7;
        byArray[6] = 69;
        byte[] Buf = byArray;
        boolean ret = this.SendPrintCMD(Buf, 7);
        Buf = null;
        this.Close();
        return ret;
    }

    public boolean ClearFlag() {
        if (!this.Open()) {
            return false;
        }
        byte[] byArray = new byte[7];
        byArray[0] = 27;
        byArray[1] = 16;
        byArray[2] = 20;
        byArray[4] = 7;
        byArray[6] = 70;
        byte[] Buf = byArray;
        boolean ret = this.SendPrintCMD(Buf, 7);
        Buf = null;
        this.Close();
        return ret;
    }

    public boolean InializeFull() {
        if (!this.Open()) {
            return false;
        }
        byte[] byArray = new byte[7];
        byArray[0] = 27;
        byArray[1] = 16;
        byArray[2] = 21;
        byArray[4] = 7;
        byArray[6] = 71;
        byte[] Buf = byArray;
        boolean ret = this.SendPrintCMD(Buf, 7);
        Buf = null;
        this.Close();
        return ret;
    }

    public boolean SetBlackOffset(int OffsetValue) {
        if (!this.Open()) {
            return false;
        }
        if (OffsetValue < 0 || OffsetValue >= 1152) {
            this.MyPerror("\u9ed1\u6807\u504f\u79fb\u91cf\u8d77\u59cb\u4f4d\u8bbe\u7f6e\u8d85\u51fa\u8303\u56f4!\n");
            BASE_ERR_CODE = 31;
            return false;
        }
        byte[] Param = new byte[]{(byte)(OffsetValue >> 8 & 0xFF), (byte)(OffsetValue & 0xFF)};
        byte[] Buf = this.GenerateStr((byte)24, Param, 2);
        boolean RtnValue = this.SendPrintCMD(Buf, 8);
        Param = null;
        Buf = null;
        this.Close();
        return RtnValue;
    }

    public boolean GetVolLimit(int[] N) {
        if (N == null || N.length < 1) {
            this.MyPerror("\u63a5\u6536\u7a7a\u95f4\u4e0d\u8db3!\n");
            BASE_ERR_CODE = 30;
            return false;
        }
        if (!this.Open()) {
            return false;
        }
        byte[] byArray = new byte[7];
        byArray[0] = 27;
        byArray[1] = 16;
        byArray[2] = 32;
        byArray[4] = 7;
        byArray[6] = 82;
        byte[] Buf = byArray;
        byte[] tmpRecBuf = new byte[2];
        boolean ret = this.SendPrintRdCMD(Buf, 7, tmpRecBuf, 1);
        if (ret) {
            N[0] = tmpRecBuf[0] & 0xFF;
            this.ReadRestChar();
        }
        Buf = null;
        tmpRecBuf = null;
        this.Close();
        return ret;
    }

    public boolean GetStartPos(int[] BeginValue) {
        if (BeginValue == null || BeginValue.length < 1) {
            this.MyPerror("\u63a5\u6536\u7a7a\u95f4\u4e0d\u8db3!\n");
            BASE_ERR_CODE = 30;
            return false;
        }
        if (!this.Open()) {
            return false;
        }
        byte[] byArray = new byte[7];
        byArray[0] = 27;
        byArray[1] = 16;
        byArray[2] = 33;
        byArray[4] = 7;
        byArray[6] = 83;
        byte[] Buf = byArray;
        byte[] tmpRecBuf = new byte[2];
        boolean ret = this.SendPrintRdCMD(Buf, 7, tmpRecBuf, 1);
        if (ret) {
            BeginValue[0] = tmpRecBuf[0] & 0xFF;
            this.ReadRestChar();
        }
        Buf = null;
        tmpRecBuf = null;
        this.Close();
        return ret;
    }

    public boolean GetSysInfo(byte[] InfoValue) {
        if (InfoValue == null || InfoValue.length < 1) {
            this.MyPerror("\u63a5\u6536\u7a7a\u95f4\u4e0d\u8db3!\n");
            BASE_ERR_CODE = 30;
            return false;
        }
        if (!this.Open()) {
            return false;
        }
        byte[] byArray = new byte[7];
        byArray[0] = 27;
        byArray[1] = 16;
        byArray[2] = 34;
        byArray[4] = 7;
        byArray[6] = 84;
        byte[] Buf = byArray;
        byte[] tmpRecBuf = new byte[2];
        boolean ret = this.SendPrintRdCMD(Buf, 7, tmpRecBuf, 1);
        if (ret) {
            InfoValue[0] = tmpRecBuf[0];
            this.ReadRestChar();
        }
        Buf = null;
        tmpRecBuf = null;
        this.Close();
        return ret;
    }

    public boolean SetBlackCheckEnabled(int Flag) {
        if (!this.Open()) {
            return false;
        }
        boolean ret = false;
        byte[] byArray = new byte[7];
        byArray[0] = 27;
        byArray[1] = 16;
        byArray[2] = 35;
        byArray[4] = 7;
        byArray[6] = 85;
        byte[] Buf1 = byArray;
        byte[] byArray2 = new byte[7];
        byArray2[0] = 27;
        byArray2[1] = 16;
        byArray2[2] = 35;
        byArray2[4] = 7;
        byArray2[5] = 1;
        byArray2[6] = 86;
        byte[] Buf2 = byArray2;
        byte[] Buf = null;
        switch (Flag) {
            case 0: {
                Buf = Buf1;
                break;
            }
            case 1: {
                Buf = Buf2;
                break;
            }
            default: {
                Buf = null;
            }
        }
        if (Buf != null) {
            ret = this.SendPrintCMD(Buf, 7);
        } else {
            this.MyPerror("\u9ed1\u6807\u68c0\u6d4b\u529f\u80fd\u4f7f\u80fd\u9009\u62e9\u8d85\u51fa\u8303\u56f4!\n");
            BASE_ERR_CODE = 31;
        }
        Buf1 = null;
        Buf2 = null;
        this.Close();
        return ret;
    }

    public boolean SetBlackCheckMode(int Mode) {
        if (!this.Open()) {
            return false;
        }
        boolean ret = false;
        byte[] byArray = new byte[7];
        byArray[0] = 27;
        byArray[1] = 16;
        byArray[2] = 36;
        byArray[4] = 7;
        byArray[6] = 86;
        byte[] Buf1 = byArray;
        byte[] byArray2 = new byte[7];
        byArray2[0] = 27;
        byArray2[1] = 16;
        byArray2[2] = 36;
        byArray2[4] = 7;
        byArray2[5] = 1;
        byArray2[6] = 87;
        byte[] Buf2 = byArray2;
        byte[] Buf = null;
        switch (Mode) {
            case 0: {
                Buf = Buf1;
                break;
            }
            case 1: {
                Buf = Buf2;
                break;
            }
            default: {
                Buf = null;
            }
        }
        if (Buf != null) {
            ret = this.SendPrintCMD(Buf, 7);
        } else {
            this.MyPerror("\u9ed1\u6807\u68c0\u6d4b\u65b9\u6cd5\u9009\u62e9\u8d85\u51fa\u8303\u56f4!\n");
            BASE_ERR_CODE = 31;
        }
        Buf1 = null;
        Buf2 = null;
        this.Close();
        return ret;
    }

    public boolean SetRtnValueMode(int Flag) {
        if (!this.Open()) {
            return false;
        }
        boolean ret = false;
        byte[] byArray = new byte[7];
        byArray[0] = 27;
        byArray[1] = 16;
        byArray[2] = 37;
        byArray[4] = 7;
        byArray[6] = 87;
        byte[] Buf1 = byArray;
        byte[] byArray2 = new byte[7];
        byArray2[0] = 27;
        byArray2[1] = 16;
        byArray2[2] = 37;
        byArray2[4] = 7;
        byArray2[5] = 1;
        byArray2[6] = 88;
        byte[] Buf2 = byArray2;
        byte[] Buf = null;
        switch (Flag) {
            case 0: {
                Buf = Buf1;
                break;
            }
            case 1: {
                Buf = Buf2;
                break;
            }
            default: {
                Buf = null;
            }
        }
        if (Buf != null) {
            ret = this.SendPrintCMD(Buf, 7);
        } else {
            this.MyPerror("\u8fd4\u56de\u503c\u5f00\u5173\u8bbe\u7f6e\u9009\u62e9\u8d85\u51fa\u8303\u56f4!\n");
            BASE_ERR_CODE = 31;
        }
        Buf1 = null;
        Buf2 = null;
        this.Close();
        return ret;
    }

    public boolean GetBIDValue(int[] BIDValue) {
        if (BIDValue == null || BIDValue.length < 1) {
            this.MyPerror("\u63a5\u6536\u7a7a\u95f4\u4e0d\u8db3!\n");
            BASE_ERR_CODE = 30;
            return false;
        }
        if (!this.Open()) {
            return false;
        }
        byte[] byArray = new byte[7];
        byArray[0] = 27;
        byArray[1] = 16;
        byArray[2] = 39;
        byArray[4] = 7;
        byArray[6] = 89;
        byte[] Buf = byArray;
        byte[] tmpRecBuf = new byte[2];
        boolean ret = this.SendPrintRdCMD(Buf, 7, tmpRecBuf, 1);
        if (ret) {
            BIDValue[0] = tmpRecBuf[0] & 0xFF;
            this.ReadRestChar();
        }
        Buf = null;
        tmpRecBuf = null;
        this.Close();
        return ret;
    }

    public boolean GetBlackOffset(int[] OffsetValue) {
        if (OffsetValue == null || OffsetValue.length < 1) {
            this.MyPerror("\u63a5\u6536\u7a7a\u95f4\u4e0d\u8db3!\n");
            BASE_ERR_CODE = 30;
            return false;
        }
        if (!this.Open()) {
            return false;
        }
        byte[] byArray = new byte[7];
        byArray[0] = 27;
        byArray[1] = 16;
        byArray[2] = 40;
        byArray[4] = 7;
        byArray[6] = 90;
        byte[] Buf = byArray;
        byte[] tmpRecBuf = new byte[3];
        boolean ret = this.SendPrintRdCMD(Buf, 7, tmpRecBuf, 2);
        if (ret) {
            OffsetValue[0] = (tmpRecBuf[0] & 0xFF) * 256 + (tmpRecBuf[1] & 0xFF);
            this.ReadRestChar();
        }
        Buf = null;
        tmpRecBuf = null;
        this.Close();
        return ret;
    }

    public boolean GetControlInfo(byte[] InfoValue) {
        if (InfoValue == null || InfoValue.length < 1) {
            this.MyPerror("\u63a5\u6536\u7a7a\u95f4\u4e0d\u8db3!\n");
            BASE_ERR_CODE = 30;
            return false;
        }
        if (!this.Open()) {
            return false;
        }
        byte[] byArray = new byte[7];
        byArray[0] = 27;
        byArray[1] = 16;
        byArray[2] = 41;
        byArray[4] = 7;
        byArray[6] = 91;
        byte[] Buf = byArray;
        byte[] tmpRecBuf = new byte[2];
        boolean ret = this.SendPrintRdCMD(Buf, 7, tmpRecBuf, 1);
        if (ret) {
            InfoValue[0] = tmpRecBuf[0];
            this.ReadRestChar();
        }
        Buf = null;
        tmpRecBuf = null;
        this.Close();
        return ret;
    }

    public boolean SetAutoFeedMode(int Flag) {
        if (!this.Open()) {
            return false;
        }
        boolean ret = false;
        byte[] byArray = new byte[7];
        byArray[0] = 27;
        byArray[1] = 16;
        byArray[2] = 42;
        byArray[4] = 7;
        byArray[6] = 92;
        byte[] Buf1 = byArray;
        byte[] byArray2 = new byte[7];
        byArray2[0] = 27;
        byArray2[1] = 16;
        byArray2[2] = 42;
        byArray2[4] = 7;
        byArray2[5] = 1;
        byArray2[6] = 93;
        byte[] Buf2 = byArray2;
        byte[] Buf = null;
        switch (Flag) {
            case 0: {
                Buf = Buf1;
                break;
            }
            case 1: {
                Buf = Buf2;
                break;
            }
            default: {
                Buf = null;
            }
        }
        if (Buf != null) {
            ret = this.SendPrintCMD(Buf, 7);
        } else {
            this.MyPerror("\u81ea\u52a8\u8fdb\u7eb8\u8bbe\u7f6e\u9009\u62e9\u8d85\u51fa\u8303\u56f4!\n");
            BASE_ERR_CODE = 31;
        }
        Buf1 = null;
        Buf2 = null;
        this.Close();
        return ret;
    }

    public boolean UnLock() {
        DevGpio dev = new DevGpio();
        int ret = dev.ELock_Unlock();
        dev = null;
        return ret >= 0;
    }

    public boolean UnLockOfCashBox() {
        DevGpio dev = new DevGpio();
        int ret = dev.CashBox_Unlock();
        return ret >= 0;
    }
}

