/*
 * Decompiled with CFR 0.152.
 */
package com.jolimark;

import com.jolimark.JmError;
import com.jolimark.SerialPort;
import jolimark.devices.DevGpio;

public class UsbPrinter {
    String DEVICE_NAME_PRINTER_4C = "/dev/lp0";
    String DEVICE_NAME_PRINTER = "/dev/usb/lp0";
    SerialPort MyPrinter = new SerialPort();
    static int BASE_ERR_CODE = 0;

    public boolean Open() {
        boolean ret = false;
        BASE_ERR_CODE = 32;
        this.oldMainBoard();
        try {
            ret = this.MyPrinter.Open(this.DEVICE_NAME_PRINTER_4C);
        }
        catch (Exception Ex) {
            return false;
        }
        BASE_ERR_CODE = 0;
        return ret;
    }

    public boolean Close() {
        boolean ret = this.MyPrinter.Close();
        return ret;
    }

    public String ReadString(int readLength) {
        if (!this.IsPrinterReady()) {
            return null;
        }
        return this.MyPrinter.ReadString(readLength);
    }

    public byte[] ReadBuf(int readLength) {
        if (!this.IsPrinterReady()) {
            return null;
        }
        return this.MyPrinter.ReadBuf(readLength);
    }

    public boolean WriteString(String sendStr) {
        boolean rtnValue = false;
        if (this.IsPrinterReady()) {
            rtnValue = this.MyPrinter.WriteString(sendStr);
        }
        return rtnValue;
    }

    public boolean WriteBuf(byte[] sendBuf, int len) {
        if (!this.IsPrinterReady()) {
            return false;
        }
        return this.MyPrinter.WriteBuf(sendBuf, len);
    }

    public boolean IsPrinterReady() {
        int usbState;
        int mState = 0;
        int i = 0;
        while (i < 3) {
            mState = this.MyPrinter.GetUsbState();
            if ((mState & 0xFF) != 255) break;
            if (i == 2) {
                BASE_ERR_CODE = 40;
                return false;
            }
            ++i;
        }
        if ((usbState = mState & 0x18) == 24) {
            return true;
        }
        BASE_ERR_CODE = 38;
        return false;
    }

    public void oldMainBoard() {
        boolean result = false;
        result = this.MyPrinter.IsUsbDevExists(this.DEVICE_NAME_PRINTER);
        if (result) {
            this.DEVICE_NAME_PRINTER_4C = this.DEVICE_NAME_PRINTER;
        }
    }

    public boolean UnLock() {
        DevGpio dev = new DevGpio();
        int ret = dev.ELock_Unlock();
        dev = null;
        return ret >= 0;
    }

    public boolean UnLockOfCashBox() {
        DevGpio dev = new DevGpio();
        int ret = dev.CashBox_Unlock();
        return ret >= 0;
    }

    public String GetLastPrintErr() {
        String errorStr = JmError.GetLastPrintErr(BASE_ERR_CODE);
        return errorStr;
    }

    public int GetLastPrintErrCode() {
        return BASE_ERR_CODE;
    }
}

