
//////////////////////////////////////////////////////////////////////
/**
 *	@file	ENSF.h
 *	@brief	ENSFCuwb_t@C
 *	@par	Copyright:<BR>
 *			(C)2010,EPSON SOFTWARE DEVELOPMENT LABORATORY, INC.
 *
 *	@par	XV
 *	@li		2010.07.01	Y.Matsuda
 *	<UL>
 *		<LI>VK쐬</LI>
 *	</UL>
 */
//////////////////////////////////////////////////////////////////////

#ifndef __ENSF_H
#define __ENSF_H

//////////////////////////////////////////////////////////////////////
// CN[h
//////////////////////////////////////////////////////////////////////
#include <windows.h>

//////////////////////////////////////////////////////////////////////
// 萔`
//////////////////////////////////////////////////////////////////////
//G[R[h
#define ENSF_STATUS_SUCCESS				0	//
#define ENSF_STATUS_ERROR				-1	//s
#define ENSF_STATUS_NOT_SUPPORTED		-2	//T|[gAPI
#define ENSF_STATUS_PARAMETER_INVALID	-3	//p[^s
#define ENSF_STATUS_BUFFER_MOREREQUIRED	-4	//obt@s


//////////////////////////////////////////////////////////////////////
// \̒`
//////////////////////////////////////////////////////////////////////
//P[uXݒ\p\
typedef struct _ENSF_CAPABILITYINFO 
{
	char*		szSSID;					//ڑς݂SSIDiݒΏۂSSIDj
	WCHAR*		pwcProfileName;			//ڑς݂̃vt@CiݒΏۂ̃vt@Cj
	bool		bSSIDAlreadyExists;		///< P[uXݒpSSIDɑ݂邩H(true:, false:Ȃ).
}SENSF_CAPABILITYINFO,*PSENSF_CAPABILITYINFO;


//////////////////////////////////////////////////////////////////////
// Windows2000ȍ~T|[gAPI
//////////////////////////////////////////////////////////////////////

/**
 *	Cũo[W擾
 *
 *	ENSFCũo[W擾
 *
 *	@param	punVersion		o[WԍiOUTj
 *	@return	ʂԂB
 *			@li	@c	ENSF_STATUS_SUCCESS				= 
 *			@li	@c	ENSF_STATUS_ERROR				= s
 *			@li	@c	ENSF_STATUS_NOT_SUPPORTED		= T|[gAPI
 *			@li	@c	ENSF_STATUS_PARAMETER_INVALID	= p[^s
 *
 */
int WINAPI GetENSFVersion(unsigned int* punVersion);

/**
 *	lbg[NI/Fgpł邩𔻒
 *
 *	݂̃lbg[Nɂălbg[NI/Fgpł邩𔻒肷
 *
 *	@param	pbEnabled		L=true =falseiOUTj
 *	@return	ʂԂB
 *			@li	@c	ENSF_STATUS_SUCCESS				= 
 *			@li	@c	ENSF_STATUS_ERROR				= s
 *			@li	@c	ENSF_STATUS_NOT_SUPPORTED		= T|[gAPI
 *			@li	@c	ENSF_STATUS_PARAMETER_INVALID	= p[^s
 *
 */
int WINAPI GetNICAvailability(bool* pbEnabled);

//////////////////////////////////////////////////////////////////////
// WindowsVistaȍ~T|[gAPI
//////////////////////////////////////////////////////////////////////

/**
 *	LAN̗L/Ԃ擾
 *
 *	LANNICۂ́A1łLȂ̂ꍇTrueƂ
 *
 *	@param	pbWirelessOn		L=true =falseiOUTj
 *	@return	ʂԂB
 *			@li	@c	ENSF_STATUS_SUCCESS				= 
 *			@li	@c	ENSF_STATUS_ERROR				= s
 *			@li	@c	ENSF_STATUS_NOT_SUPPORTED		= T|[gAPI
 *			@li	@c	ENSF_STATUS_PARAMETER_INVALID	= p[^s
 *
 */
int WINAPI GetWirelessLANStatus(bool* pbWirelessOn);

/**
 *	P[uXݒ肪\ǂ𔻒
 *
 *	݂̃lbg[NɂăP[uXݒ肪\ǂ𔻒肷
 *
 *	@param	pszHwType		n[hEFA^CviINj
*	@param	pbCablelessSetupEnable		WAC\=True WACs\=FalseiOUTj
 *	@param	pData			ʂi[o̓obt@iOUTj
 *	@param	punDataSize		o̓obt@TCYiIN/OUTj
 *	@return	ʂԂB
 *			@li	@c	ENSF_STATUS_SUCCESS				= 
 *			@li	@c	ENSF_STATUS_ERROR				= s
 *			@li	@c	ENSF_STATUS_NOT_SUPPORTED		= T|[gAPI
 *			@li	@c	ENSF_STATUS_PARAMETER_INVALID	= p[^s
  *			@li	@c	ENSF_STATUS_BUFFER_MOREREQUIRED	=@obt@s
 *
 */
int WINAPI GetCablelessSetupCapability(const char* pszHwType,bool* pbCablelessSetupEnable,void* pData,unsigned int* punDataSize);


#endif // __ENSF_H